/*
 * Decompiled with CFR 0.152.
 */
package nsusbloader.cli;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import nsusbloader.cli.IncorrectSetupException;
import nsusbloader.com.net.NETCommunications;

public class TinfoilNetCli {
    private final String[] arguments;
    private String nsIp;
    private String hostIp = "";
    private String hostPortNum = "";
    private int parseFileSince = 1;
    private List<File> filesList;

    TinfoilNetCli(String[] arguments) throws InterruptedException, IncorrectSetupException {
        this.arguments = arguments;
        this.checkArguments();
        this.parseNsIP();
        this.parseHostSettings();
        this.parseFilesArguments();
        this.runTinfoilNetBackend();
    }

    private void checkArguments() throws IncorrectSetupException {
        if (this.arguments == null || this.arguments.length == 0) {
            throw new IncorrectSetupException("No arguments.\nTry 'ns-usbloader -n help' for more information.");
        }
        if (this.arguments.length == 1) {
            if (this.isHelpDirective(this.arguments[0])) {
                this.showHelp();
                return;
            }
            throw new IncorrectSetupException("Not enough arguments.\nTry 'ns-usbloader -n help' for more information.");
        }
        if (this.arguments.length == 2 && this.arguments[1].startsWith("hostip=")) {
            throw new IncorrectSetupException("Not enough arguments.\nTry 'ns-usbloader -n help' for more information.");
        }
    }

    private boolean isHelpDirective(String argument) {
        return argument.equals("help");
    }

    private void showHelp() throws IncorrectSetupException {
        throw new IncorrectSetupException("Usage:\n\tns-usbloader -n nsip=<arg1> [hostip=<arg2>] FILE1 ...\n\tns-usbloader --tfn nsip=<arg1> [hostip=<arg2>] FILE1 ...\n\nOptions:\n\tnsip=<ip>\t\tDefine NS IP address (mandatory)\n\thostip=<ip[:port]>\tDefine this host IP address. Will be obtained automatically if not set.");
    }

    private void parseNsIP() throws IncorrectSetupException {
        String argument1 = this.arguments[0];
        if (!argument1.startsWith("nsip=")) {
            throw new IncorrectSetupException("First argument must be 'nsip=<ip_address>'\nTry 'ns-usbloader -n help' for more information.");
        }
        this.nsIp = argument1.replaceAll("^nsip=", "");
        if (this.nsIp.isEmpty()) {
            throw new IncorrectSetupException("No spaces allowed before or after 'nsip=<ip_address>' argument.\nTry 'ns-usbloader -n help' for more information.");
        }
    }

    private void parseHostSettings() {
        String argument2 = this.arguments[1];
        if (!argument2.startsWith("hostip=")) {
            return;
        }
        this.parseFileSince = 2;
        this.hostIp = argument2.replaceAll("(^hostip=)|(:.+?$)|(:$)", "");
        if (argument2.contains(":")) {
            this.hostPortNum = argument2.replaceAll("(^.+:)", "");
        }
    }

    private void parseFilesArguments() throws IncorrectSetupException {
        this.filesList = new ArrayList<File>();
        while (this.parseFileSince < this.arguments.length) {
            File file = new File(this.arguments[this.parseFileSince]);
            if (file.exists()) {
                this.filesList.add(file);
            }
            ++this.parseFileSince;
        }
        if (this.filesList.size() == 0) {
            throw new IncorrectSetupException("File(s) doesn't exist.\nTry 'ns-usbloader -n help' for more information.");
        }
    }

    private void runTinfoilNetBackend() throws InterruptedException {
        NETCommunications netCommunications = new NETCommunications(this.filesList, this.nsIp, false, this.hostIp, this.hostPortNum, "");
        Thread netCommThread = new Thread(netCommunications);
        netCommThread.setDaemon(true);
        netCommThread.start();
        netCommThread.join();
    }
}

