/*
 * Decompiled with CFR 0.152.
 */
package nsusbloader.com.net;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import nsusbloader.ModelControllers.ILogPrinter;
import nsusbloader.NSLDataTypes.EMsgType;
import nsusbloader.com.net.UniFile;

public class NetworkSetupValidator {
    private String hostIP;
    private int hostPort;
    private final HashMap<String, UniFile> files = new HashMap();
    private ServerSocket serverSocket;
    private final boolean valid;
    private final ILogPrinter logPrinter;
    private final boolean doNotServe;

    NetworkSetupValidator(List<File> filesList, boolean doNotServe, String hostIP, String hostPortNum, ILogPrinter logPrinter) {
        this.logPrinter = logPrinter;
        this.doNotServe = doNotServe;
        try {
            this.validateFiles(filesList);
            this.encodeAndAddFilesToMap(filesList);
            this.resolveIp(hostIP);
            this.resolvePort(hostPortNum);
        }
        catch (Exception e) {
            try {
                logPrinter.print(e.getMessage(), EMsgType.FAIL);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.valid = false;
            return;
        }
        this.valid = true;
    }

    private void validateFiles(List<File> filesList) {
        filesList.removeIf(this::validator);
    }

    private boolean validator(File f) {
        try {
            if (f.isFile()) {
                return false;
            }
            File[] subFiles = f.listFiles((file, name) -> name.matches("[0-9]{2}"));
            if (subFiles == null || subFiles.length == 0) {
                this.logPrinter.print("NET: Exclude folder: " + f.getName(), EMsgType.WARNING);
                return true;
            }
            Arrays.sort(subFiles, Comparator.comparingInt(file -> Integer.parseInt(file.getName())));
            for (int i = subFiles.length - 2; i > 0; --i) {
                if (subFiles[i].length() == subFiles[i - 1].length()) continue;
                this.logPrinter.print("NET: Exclude split file: " + f.getName() + "\n      Chunk sizes of the split file are not the same, but has to be.", EMsgType.WARNING);
                return true;
            }
            long firstFileLength = subFiles[0].length();
            long lastFileLength = subFiles[subFiles.length - 1].length();
            if (lastFileLength > firstFileLength) {
                this.logPrinter.print("NET: Exclude split file: " + f.getName() + "\n      Chunk sizes of the split file are not the same, but has to be.", EMsgType.WARNING);
                return true;
            }
            return false;
        }
        catch (InterruptedException ie) {
            return false;
        }
    }

    private void encodeAndAddFilesToMap(List<File> filesList) throws UnsupportedEncodingException, FileNotFoundException {
        for (File file : filesList) {
            String encodedName = URLEncoder.encode(file.getName(), "UTF-8").replaceAll("\\+", "%20");
            UniFile uniFile = new UniFile(file);
            this.files.put(encodedName, uniFile);
        }
        if (this.files.size() == 0) {
            throw new FileNotFoundException("NET: No files to send.");
        }
    }

    private void resolveIp(String hostIPaddr) throws IOException, InterruptedException {
        if (!hostIPaddr.isEmpty()) {
            this.hostIP = hostIPaddr;
            this.logPrinter.print("NET: Host IP defined as: " + this.hostIP, EMsgType.PASS);
            return;
        }
        if (this.findIpLocally()) {
            return;
        }
        if (this.findIpUsingHost("google.com")) {
            return;
        }
        if (this.findIpUsingHost("people.com.cn")) {
            return;
        }
        throw new IOException("Try using 'Expert mode' and set IP manually. " + this.getAvaliableIpExamples());
    }

    private boolean findIpUsingHost(String host) throws InterruptedException {
        try {
            Socket scoketK = new Socket();
            scoketK.connect(new InetSocketAddress(host, 80));
            this.hostIP = scoketK.getLocalAddress().getHostAddress();
            scoketK.close();
            this.logPrinter.print("NET: Host IP detected as: " + this.hostIP, EMsgType.PASS);
            return true;
        }
        catch (IOException e) {
            this.logPrinter.print("NET: Can't get your computer IP using " + host + " server (InetSocketAddress). Returned:\n\t" + e.getMessage(), EMsgType.INFO);
            return false;
        }
    }

    private boolean findIpLocally() throws InterruptedException {
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface iface = interfaces.nextElement();
                if (iface.isLoopback() || !iface.isUp()) continue;
                Enumeration<InetAddress> addresses = iface.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress addr = addresses.nextElement();
                    if (!(addr instanceof Inet4Address) || addr.isLoopbackAddress()) continue;
                    this.hostIP = addr.getHostAddress();
                    this.logPrinter.print("NET: Host IP detected locally as: " + this.hostIP, EMsgType.PASS);
                    return true;
                }
            }
        }
        catch (SocketException e) {
            this.logPrinter.print("NET: Error scanning local adapters: " + e.getMessage(), EMsgType.INFO);
        }
        return false;
    }

    private String getAvaliableIpExamples() {
        try {
            StringBuilder builder = new StringBuilder("Check for:\n");
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                NetworkInterface n = enumeration.nextElement();
                Enumeration<InetAddress> enumeration1 = n.getInetAddresses();
                while (enumeration1.hasMoreElements()) {
                    builder.append("- ");
                    builder.append(enumeration1.nextElement().getHostAddress());
                    builder.append("\n");
                }
            }
            return builder.toString();
        }
        catch (SocketException socketException) {
            return "";
        }
    }

    private void resolvePort(String hostPortNum) throws Exception {
        if (!hostPortNum.isEmpty()) {
            this.parsePort(hostPortNum);
            return;
        }
        if (this.doNotServe) {
            throw new Exception("NET: Port must be defined if 'Don't serve requests' option selected!");
        }
        this.findPort();
    }

    private void findPort() throws Exception {
        Random portRandomizer = new Random();
        for (int i = 0; i < 5; ++i) {
            try {
                this.hostPort = portRandomizer.nextInt(999) + 6000;
                this.serverSocket = new ServerSocket(this.hostPort);
                this.logPrinter.print("NET: Your port detected as: " + this.hostPort, EMsgType.PASS);
                break;
            }
            catch (IOException ioe) {
                if (i == 4) {
                    throw new Exception("NET: Can't find good port\nSet port by in settings ('Expert mode').");
                }
                this.logPrinter.print("NET: Can't use port " + this.hostPort + "\nLooking for another one.", EMsgType.WARNING);
                continue;
            }
        }
    }

    private void parsePort(String hostPortNum) throws Exception {
        try {
            this.hostPort = Integer.parseInt(hostPortNum);
            if (this.doNotServe) {
                return;
            }
            this.serverSocket = new ServerSocket(this.hostPort);
            this.logPrinter.print("NET: Using defined port number: " + this.hostPort, EMsgType.PASS);
        }
        catch (IOException | IllegalArgumentException eee) {
            throw new Exception("NET: Can't use port defined in settings: " + hostPortNum + "\n\t" + eee.getMessage());
        }
    }

    String getHostIP() {
        return this.hostIP;
    }

    int getHostPort() {
        return this.hostPort;
    }

    HashMap<String, UniFile> getFiles() {
        return this.files;
    }

    ServerSocket getServerSocket() {
        return this.serverSocket;
    }

    boolean isValid() {
        return this.valid;
    }
}

