/*
 * Decompiled with CFR 0.152.
 */
package libKonogonka.fs.NCA.NCASectionTableBlock;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import libKonogonka.Converter;

public class SuperBlockIVFC {
    private final String magic;
    private final int version;
    private final int masterHashSize;
    private final int totalNumberOfLevels;
    private final long lvl1Offset;
    private final long lvl1Size;
    private final int lvl1SBlockSize;
    private final byte[] reserved1;
    private final long lvl2Offset;
    private final long lvl2Size;
    private final int lvl2SBlockSize;
    private final byte[] reserved2;
    private final long lvl3Offset;
    private final long lvl3Size;
    private final int lvl3SBlockSize;
    private final byte[] reserved3;
    private final long lvl4Offset;
    private final long lvl4Size;
    private final int lvl4SBlockSize;
    private final byte[] reserved4;
    private final long lvl5Offset;
    private final long lvl5Size;
    private final int lvl5SBlockSize;
    private final byte[] reserved5;
    private final long lvl6Offset;
    private final long lvl6Size;
    private final int lvl6SBlockSize;
    private final byte[] reserved6;
    private final byte[] signatureSalt;
    private final byte[] masterHash;
    private final byte[] reservedTail;

    SuperBlockIVFC(byte[] sbBytes) {
        this.magic = new String(Arrays.copyOfRange(sbBytes, 0, 4), StandardCharsets.US_ASCII);
        this.version = Converter.getLEint(sbBytes, 4);
        this.masterHashSize = Converter.getLEint(sbBytes, 8);
        this.totalNumberOfLevels = Converter.getLEint(sbBytes, 12);
        this.lvl1Offset = Converter.getLElong(sbBytes, 16);
        this.lvl1Size = Converter.getLElong(sbBytes, 24);
        this.lvl1SBlockSize = Converter.getLEint(sbBytes, 32);
        this.reserved1 = Arrays.copyOfRange(sbBytes, 36, 40);
        this.lvl2Offset = Converter.getLElong(sbBytes, 40);
        this.lvl2Size = Converter.getLElong(sbBytes, 48);
        this.lvl2SBlockSize = Converter.getLEint(sbBytes, 56);
        this.reserved2 = Arrays.copyOfRange(sbBytes, 60, 64);
        this.lvl3Offset = Converter.getLElong(sbBytes, 64);
        this.lvl3Size = Converter.getLElong(sbBytes, 72);
        this.lvl3SBlockSize = Converter.getLEint(sbBytes, 80);
        this.reserved3 = Arrays.copyOfRange(sbBytes, 84, 88);
        this.lvl4Offset = Converter.getLElong(sbBytes, 88);
        this.lvl4Size = Converter.getLElong(sbBytes, 96);
        this.lvl4SBlockSize = Converter.getLEint(sbBytes, 104);
        this.reserved4 = Arrays.copyOfRange(sbBytes, 108, 112);
        this.lvl5Offset = Converter.getLElong(sbBytes, 112);
        this.lvl5Size = Converter.getLElong(sbBytes, 120);
        this.lvl5SBlockSize = Converter.getLEint(sbBytes, 128);
        this.reserved5 = Arrays.copyOfRange(sbBytes, 132, 136);
        this.lvl6Offset = Converter.getLElong(sbBytes, 136);
        this.lvl6Size = Converter.getLElong(sbBytes, 144);
        this.lvl6SBlockSize = Converter.getLEint(sbBytes, 152);
        this.reserved6 = Arrays.copyOfRange(sbBytes, 156, 160);
        this.signatureSalt = Arrays.copyOfRange(sbBytes, 160, 192);
        this.masterHash = Arrays.copyOfRange(sbBytes, 192, 224);
        this.reservedTail = Arrays.copyOfRange(sbBytes, 224, 248);
    }

    public String getMagic() {
        return this.magic;
    }

    public int getVersion() {
        return this.version;
    }

    public int getMasterHashSize() {
        return this.masterHashSize;
    }

    public int getTotalNumberOfLevels() {
        return this.totalNumberOfLevels;
    }

    public long getLvl1Offset() {
        return this.lvl1Offset;
    }

    public long getLvl1Size() {
        return this.lvl1Size;
    }

    public int getLvl1SBlockSize() {
        return this.lvl1SBlockSize;
    }

    public byte[] getReserved1() {
        return this.reserved1;
    }

    public long getLvl2Offset() {
        return this.lvl2Offset;
    }

    public long getLvl2Size() {
        return this.lvl2Size;
    }

    public int getLvl2SBlockSize() {
        return this.lvl2SBlockSize;
    }

    public byte[] getReserved2() {
        return this.reserved2;
    }

    public long getLvl3Offset() {
        return this.lvl3Offset;
    }

    public long getLvl3Size() {
        return this.lvl3Size;
    }

    public int getLvl3SBlockSize() {
        return this.lvl3SBlockSize;
    }

    public byte[] getReserved3() {
        return this.reserved3;
    }

    public long getLvl4Offset() {
        return this.lvl4Offset;
    }

    public long getLvl4Size() {
        return this.lvl4Size;
    }

    public int getLvl4SBlockSize() {
        return this.lvl4SBlockSize;
    }

    public byte[] getReserved4() {
        return this.reserved4;
    }

    public long getLvl5Offset() {
        return this.lvl5Offset;
    }

    public long getLvl5Size() {
        return this.lvl5Size;
    }

    public int getLvl5SBlockSize() {
        return this.lvl5SBlockSize;
    }

    public byte[] getReserved5() {
        return this.reserved5;
    }

    public long getLvl6Offset() {
        return this.lvl6Offset;
    }

    public long getLvl6Size() {
        return this.lvl6Size;
    }

    public int getLvl6SBlockSize() {
        return this.lvl6SBlockSize;
    }

    public byte[] getReserved6() {
        return this.reserved6;
    }

    public byte[] getSignatureSalt() {
        return this.signatureSalt;
    }

    public byte[] getMasterHash() {
        return this.masterHash;
    }

    public byte[] getReservedTail() {
        return this.reservedTail;
    }
}

