/*
 * Decompiled with CFR 0.152.
 */
package nsusbloader.Controllers;

import java.net.URL;
import java.util.List;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TextArea;
import nsusbloader.AppPreferences;
import nsusbloader.Controllers.GamesController;
import nsusbloader.Controllers.NxdtController;
import nsusbloader.Controllers.PatchesController;
import nsusbloader.Controllers.RcmController;
import nsusbloader.Controllers.SettingsController;
import nsusbloader.Controllers.SplitMergeController;
import nsusbloader.MediatorControl;
import nsusbloader.ModelControllers.UpdatesChecker;
import nsusbloader.NSLMain;
import nsusbloader.ServiceWindow;
import nsusbloader.TransfersPublisher;

public class NSLMainController
implements Initializable {
    private ResourceBundle resourceBundle;
    @FXML
    private TextArea logArea;
    @FXML
    private ProgressBar progressBar;
    @FXML
    private TabPane mainTabPane;
    @FXML
    private Tab GamesTabHolder;
    @FXML
    private Tab RCMTabHolder;
    @FXML
    private Tab SMTabHolder;
    @FXML
    private Tab PatchesTabHolder;
    @FXML
    private GamesController GamesTabController;
    @FXML
    private SettingsController SettingsTabController;
    @FXML
    private SplitMergeController SplitMergeTabController;
    @FXML
    private RcmController RcmTabController;
    @FXML
    private NxdtController NXDTabController;
    @FXML
    private PatchesController PatchesTabController;

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        this.resourceBundle = rb;
        this.logArea.setText(rb.getString("tab3_Txt_GreetingsMessage") + " " + NSLMain.appVersion + "!\n");
        if (System.getProperty("os.name").toLowerCase().startsWith("lin") && !System.getProperty("user.name").equals("root")) {
            this.logArea.appendText(rb.getString("tab3_Txt_EnteredAsMsg1") + System.getProperty("user.name") + "\n" + rb.getString("tab3_Txt_EnteredAsMsg2") + "\n");
        }
        this.logArea.appendText(rb.getString("tab3_Txt_GreetingsMessage2") + "\n");
        AppPreferences preferences = AppPreferences.getInstance();
        if (preferences.getAutoCheckUpdates()) {
            this.checkForUpdates();
        }
        if (preferences.getPatchesTabInvisible()) {
            this.mainTabPane.getTabs().remove(3);
        }
        this.openLastOpenedTab();
        TransfersPublisher transfersPublisher = new TransfersPublisher(this.GamesTabController, this.SplitMergeTabController, this.RcmTabController, this.NXDTabController, this.PatchesTabController);
        MediatorControl.INSTANCE.configure(this.resourceBundle, this.SettingsTabController, this.logArea, this.progressBar, this.GamesTabController, transfersPublisher);
    }

    private void checkForUpdates() {
        UpdatesChecker updTask = new UpdatesChecker();
        updTask.setOnSucceeded(event -> {
            List result = (List)updTask.getValue();
            if (result != null) {
                if (!((String)result.get(0)).isEmpty()) {
                    this.SettingsTabController.getGenericSettings().setNewVersionLink((String)result.get(0));
                    ServiceWindow.getInfoNotification(this.resourceBundle.getString("windowTitleNewVersionAval"), this.resourceBundle.getString("windowTitleNewVersionAval") + ": " + (String)result.get(0) + "\n\n" + (String)result.get(1));
                }
            } else {
                ServiceWindow.getInfoNotification(this.resourceBundle.getString("windowTitleNewVersionUnknown"), this.resourceBundle.getString("windowBodyNewVersionUnknown"));
            }
        });
        Thread updates = new Thread(updTask);
        updates.setDaemon(true);
        updates.start();
    }

    public void exit() {
        this.GamesTabController.updatePreferencesOnExit();
        this.SettingsTabController.updatePreferencesOnExit();
        this.SplitMergeTabController.updatePreferencesOnExit();
        this.RcmTabController.updatePreferencesOnExit();
        this.NXDTabController.updatePreferencesOnExit();
        this.PatchesTabController.updatePreferencesOnExit();
        this.saveLastOpenedTab();
    }

    private void openLastOpenedTab() {
        String tabId;
        switch (tabId = AppPreferences.getInstance().getLastOpenedTab()) {
            case "GamesTabHolder": {
                this.mainTabPane.getSelectionModel().select(this.GamesTabHolder);
                break;
            }
            case "RCMTabHolder": {
                this.mainTabPane.getSelectionModel().select(this.RCMTabHolder);
                break;
            }
            case "SMTabHolder": {
                this.mainTabPane.getSelectionModel().select(this.SMTabHolder);
                break;
            }
            case "PatchesTabHolder": {
                this.mainTabPane.getSelectionModel().select(this.PatchesTabHolder);
            }
        }
    }

    private void saveLastOpenedTab() {
        String tabId = ((Tab)this.mainTabPane.getSelectionModel().getSelectedItem()).getId();
        if (tabId == null || tabId.isEmpty()) {
            tabId = "";
        }
        AppPreferences.getInstance().setLastOpenedTab(tabId);
    }
}

