/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.layout;

import com.sun.javafx.PlatformUtil;
import java.util.Objects;
import javafx.beans.value.ObservableValue;
import javafx.css.PseudoClass;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HeaderButtonType;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import javafx.util.Subscription;

public final class HeaderButtonBehavior
implements EventHandler<Event> {
    private static final PseudoClass MAXIMIZED_PSEUDO_CLASS = PseudoClass.getPseudoClass("maximized");
    private final Node node;
    private final HeaderButtonType type;
    private final Subscription subscription;

    public HeaderButtonBehavior(Node node, HeaderButtonType headerButtonType) {
        this.node = Objects.requireNonNull(node);
        this.type = Objects.requireNonNull(headerButtonType);
        ObservableValue<Stage> observableValue = node.sceneProperty().flatMap(Scene::windowProperty).map(window -> {
            Stage stage;
            return window instanceof Stage ? (stage = (Stage)window) : null;
        });
        Subscription subscription = Subscription.combine(observableValue.flatMap(Stage::fullScreenProperty).subscribe(this::onFullScreenChanged), () -> node.removeEventHandler(MouseEvent.MOUSE_RELEASED, this));
        if (headerButtonType != HeaderButtonType.CLOSE) {
            subscription = Subscription.combine(subscription, observableValue.subscribe(this::onStageChanged), observableValue.flatMap(Stage::resizableProperty).subscribe(this::onResizableChanged), () -> {
                Stage stage = this.getStage();
                if (stage instanceof Stage) {
                    Stage stage2 = stage;
                    stage2.removeEventFilter(WindowEvent.WINDOW_SHOWING, this);
                }
            });
        }
        if (headerButtonType == HeaderButtonType.MAXIMIZE) {
            subscription = Subscription.combine(subscription, observableValue.flatMap(Stage::maximizedProperty).subscribe(this::onMaximizedChanged));
        }
        this.subscription = subscription;
        node.addEventHandler(MouseEvent.MOUSE_RELEASED, this);
        if (!node.focusTraversableProperty().isBound()) {
            node.setFocusTraversable(false);
        }
    }

    public void dispose() {
        this.subscription.unsubscribe();
    }

    @Override
    public void handle(Event event) {
        if (event instanceof MouseEvent) {
            MouseEvent mouseEvent = (MouseEvent)event;
            this.handleMouseEvent(mouseEvent);
        } else if (event instanceof WindowEvent) {
            WindowEvent windowEvent = (WindowEvent)event;
            this.handleWindowEvent(windowEvent);
        }
    }

    private void handleMouseEvent(MouseEvent mouseEvent) {
        if (!this.node.getLayoutBounds().contains(mouseEvent.getX(), mouseEvent.getY()) || mouseEvent.getButton() != MouseButton.PRIMARY) {
            return;
        }
        Stage stage = this.getStage();
        if (stage == null) {
            return;
        }
        switch (this.type) {
            case CLOSE: {
                Event.fireEvent(stage, new WindowEvent(stage, WindowEvent.WINDOW_CLOSE_REQUEST));
                break;
            }
            case ICONIFY: {
                stage.setIconified(true);
                break;
            }
            case MAXIMIZE: {
                if (PlatformUtil.isMac() && stage.getModality() == Modality.NONE && !mouseEvent.isAltDown()) {
                    stage.setFullScreen(!stage.isFullScreen());
                    break;
                }
                stage.setMaximized(!stage.isMaximized());
            }
        }
    }

    private void handleWindowEvent(WindowEvent windowEvent) {
        Stage stage;
        if (windowEvent.getEventType() == WindowEvent.WINDOW_SHOWING && (stage = this.getStage()) instanceof Stage) {
            Stage stage2 = stage;
            this.updateButtonDisableState(stage2);
        }
    }

    private Stage getStage() {
        Stage stage;
        Scene scene = this.node.getScene();
        if (scene == null) {
            return null;
        }
        Window window = scene.getWindow();
        return window instanceof Stage ? (stage = (Stage)window) : null;
    }

    private void onStageChanged(Stage stage, Stage stage2) {
        if (stage != null) {
            stage.removeEventFilter(WindowEvent.WINDOW_SHOWING, this);
        }
        if (stage2 != null) {
            stage2.addEventFilter(WindowEvent.WINDOW_SHOWING, this);
        }
    }

    private void onResizableChanged(Boolean bl) {
        Stage stage = this.getStage();
        if (stage instanceof Stage) {
            Stage stage2 = stage;
            this.updateButtonDisableState(stage2);
        }
    }

    private void updateButtonDisableState(Stage stage) {
        if (!this.node.disableProperty().isBound()) {
            boolean bl = stage.getStyle() == StageStyle.UTILITY;
            boolean bl2 = stage.getOwner() != null || stage.getModality() != Modality.NONE;
            boolean bl3 = stage.isResizable();
            switch (this.type) {
                case ICONIFY: {
                    this.node.setDisable(bl || bl2);
                    break;
                }
                case MAXIMIZE: {
                    this.node.setDisable(!bl3);
                }
            }
        }
    }

    private void onFullScreenChanged(Boolean bl) {
        if (!this.node.visibleProperty().isBound() && !this.node.managedProperty().isBound()) {
            this.node.setVisible(bl != Boolean.TRUE);
            this.node.setManaged(bl != Boolean.TRUE);
        }
    }

    private void onMaximizedChanged(Boolean bl) {
        this.node.pseudoClassStateChanged(MAXIMIZED_PSEUDO_CLASS, bl == Boolean.TRUE);
    }
}

