/*
 * Decompiled with CFR 0.152.
 */
package libKonogonka.fs.RomFs;

import libKonogonka.Converter;
import libKonogonka.RainbowDump;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Level6Header {
    private static final Logger log = LogManager.getLogger(Level6Header.class);
    private final long headerLength;
    private final long directoryHashTableOffset;
    private final long directoryHashTableLength;
    private final long directoryMetadataTableOffset;
    private final long directoryMetadataTableLength;
    private final long fileHashTableOffset;
    private final long fileHashTableLength;
    private final long fileMetadataTableOffset;
    private final long fileMetadataTableLength;
    private final long fileDataOffset;
    private final byte[] headerBytes;
    private int _cursor;

    Level6Header(byte[] headerBytes) throws Exception {
        this.headerBytes = headerBytes;
        if (headerBytes.length < 80) {
            throw new Exception("Level 6 Header section is too small");
        }
        this.headerLength = this.getNext();
        this.directoryHashTableOffset = this.getNext();
        this.directoryHashTableLength = this.getNext();
        this.directoryMetadataTableOffset = this.getNext();
        this.directoryMetadataTableLength = this.getNext();
        this.fileHashTableOffset = this.getNext();
        this.fileHashTableLength = this.getNext();
        this.fileMetadataTableOffset = this.getNext();
        this.fileMetadataTableLength = this.getNext();
        this.fileDataOffset = this.getNext();
    }

    private long getNext() {
        long result = Converter.getLElongOfInt(this.headerBytes, this._cursor);
        this._cursor += 8;
        return result;
    }

    public long getHeaderLength() {
        return this.headerLength;
    }

    public long getDirectoryHashTableOffset() {
        return this.directoryHashTableOffset;
    }

    public long getDirectoryHashTableLength() {
        return this.directoryHashTableLength;
    }

    public long getDirectoryMetadataTableOffset() {
        return this.directoryMetadataTableOffset;
    }

    public long getDirectoryMetadataTableLength() {
        return this.directoryMetadataTableLength;
    }

    public long getFileHashTableOffset() {
        return this.fileHashTableOffset;
    }

    public long getFileHashTableLength() {
        return this.fileHashTableLength;
    }

    public long getFileMetadataTableOffset() {
        return this.fileMetadataTableOffset;
    }

    public long getFileMetadataTableLength() {
        return this.fileMetadataTableLength;
    }

    public long getFileDataOffset() {
        return this.fileDataOffset;
    }

    public void printDebugInfo() {
        log.debug("== Level 6 Header ==\nHeader Length (usually 0x50)          " + RainbowDump.formatDecHexString(this.headerLength) + "   (size of this structure within first 0x200 block of LEVEL 6 part)\nDirectory Hash Table Offset           " + RainbowDump.formatDecHexString(this.directoryHashTableOffset) + "   (against THIS block where HEADER contains)\nDirectory Hash Table Length           " + RainbowDump.formatDecHexString(this.directoryHashTableLength) + "\nDirectory Metadata Table Offset       " + RainbowDump.formatDecHexString(this.directoryMetadataTableOffset) + "\nDirectory Metadata Table Length       " + RainbowDump.formatDecHexString(this.directoryMetadataTableLength) + "\nFile Hash Table Offset                " + RainbowDump.formatDecHexString(this.fileHashTableOffset) + "\nFile Hash Table Length                " + RainbowDump.formatDecHexString(this.fileHashTableLength) + "\nFile Metadata Table Offset            " + RainbowDump.formatDecHexString(this.fileMetadataTableOffset) + "\nFile Metadata Table Length            " + RainbowDump.formatDecHexString(this.fileMetadataTableLength) + "\nFile Data Offset                      " + RainbowDump.formatDecHexString(this.fileDataOffset) + "\n-------------------------------------------------------------");
    }
}

