/*
 * Decompiled with CFR 0.152.
 */
package libKonogonka.fs.RomFs.view;

import java.util.List;
import libKonogonka.fs.RomFs.FileSystemEntry;

public class FileSystemTreeViewMaker {
    private StringBuilder tree;
    private int spacerForSizes;

    private FileSystemTreeViewMaker() {
    }

    private void init(List<FileSystemEntry> content) {
        this.tree = new StringBuilder("/\n");
        for (FileSystemEntry entry : content) {
            this.printEntry(2, entry);
        }
    }

    private void printEntry(int count, FileSystemEntry entry) {
        int i;
        for (i = 0; i < count; ++i) {
            this.tree.append(" ");
        }
        if (entry.isDirectory()) {
            this.tree.append("|-");
            this.tree.append(entry.getName());
            this.tree.append("\n");
            for (FileSystemEntry e : entry.getContent()) {
                this.printEntry(count + 2, e);
            }
            return;
        }
        this.tree.append("|-");
        this.tree.append(entry.getName());
        this.tree.append(String.format("%" + (this.spacerForSizes - entry.getName().length() - i) + "s0x%-10x 0x%-10x", "", entry.getOffset(), entry.getSize()));
        this.tree.append("\n");
    }

    public static String make(List<FileSystemEntry> content, int spacerForSizes) {
        FileSystemTreeViewMaker maker = new FileSystemTreeViewMaker();
        maker.spacerForSizes = spacerForSizes;
        maker.init(content);
        return maker.tree.toString();
    }
}

