/*
 * Decompiled with CFR 0.152.
 */
package libKonogonka.fs.other.System2.ini1;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import libKonogonka.aesctr.InFileStreamClassicProducer;
import libKonogonka.blz.BlzDecompress;
import libKonogonka.fs.NSO.SegmentHeader;
import libKonogonka.fs.other.System2.ini1.KIP1Header;
import libKonogonka.fs.other.System2.ini1.KIP1Raw;

public class Kip1Unpacker {
    private static final String DECOMPRESSED_FILE_POSTFIX = "_decompressed";
    private final KIP1Header kip1Header;
    private final InFileStreamClassicProducer producer;
    private byte[] header;
    private byte[] _textDecompressedSection;
    private byte[] _roDataDecompressedSection;
    private byte[] _rwDataDecompressedSection;
    private int textFileOffsetNew;
    private int roDataFileOffsetNew;

    private Kip1Unpacker(KIP1Header kip1Header, InFileStreamClassicProducer producer) throws Exception {
        this.kip1Header = kip1Header;
        this.producer = producer;
        this.decompressSections();
        this.makeHeader();
    }

    static boolean unpack(KIP1Header kip1Header, InFileStreamClassicProducer producer, String saveToLocation) throws Exception {
        if (!(kip1Header.isTextCompressFlag() || kip1Header.isRoDataCompressFlag() || kip1Header.isRwDataCompressFlag())) {
            throw new Exception("This file is not compressed. Use 'export(location)' method instead.");
        }
        Kip1Unpacker instance = new Kip1Unpacker(kip1Header, producer);
        instance.writeFile(saveToLocation);
        return true;
    }

    static KIP1Raw getKIP1Raw(KIP1Header kip1Header, InFileStreamClassicProducer producer) throws Exception {
        Kip1Unpacker instance = new Kip1Unpacker(kip1Header, producer);
        return new KIP1Raw(instance.header, instance._textDecompressedSection, instance._roDataDecompressedSection, instance._rwDataDecompressedSection);
    }

    private void decompressSections() throws Exception {
        this.decompressTextSection();
        this.decompressRoDataSection();
        this.decompressRwDataSection();
    }

    private void decompressTextSection() throws Exception {
        this._textDecompressedSection = this.kip1Header.isTextCompressFlag() ? this.decompressSection(this.kip1Header.getTextSegmentHeader(), 256) : this.duplicateSection(this.kip1Header.getTextSegmentHeader(), 256);
    }

    private void decompressRoDataSection() throws Exception {
        int offset = 256 + this.kip1Header.getTextSegmentHeader().getSize();
        this._roDataDecompressedSection = this.kip1Header.isRoDataCompressFlag() ? this.decompressSection(this.kip1Header.getRoDataSegmentHeader(), offset) : this.duplicateSection(this.kip1Header.getRoDataSegmentHeader(), offset);
    }

    private void decompressRwDataSection() throws Exception {
        int offset = 256 + this.kip1Header.getTextSegmentHeader().getSize() + this.kip1Header.getRoDataSegmentHeader().getSize();
        this._rwDataDecompressedSection = this.kip1Header.isRwDataCompressFlag() ? this.decompressSection(this.kip1Header.getRwDataSegmentHeader(), offset) : this.duplicateSection(this.kip1Header.getRwDataSegmentHeader(), offset);
    }

    private byte[] decompressSection(SegmentHeader segmentHeader, int offset) throws Exception {
        try (BufferedInputStream stream = this.producer.produce();){
            int sectionDecompressedSize = segmentHeader.getMemoryOffset();
            byte[] compressed = new byte[segmentHeader.getSize()];
            if ((long)offset != stream.skip(offset)) {
                throw new Exception("Failed to skip " + offset + " bytes till section");
            }
            if (segmentHeader.getSize() != stream.read(compressed)) {
                throw new Exception("Failed to read entire section");
            }
            BlzDecompress decompressor = new BlzDecompress();
            byte[] restored = new byte[sectionDecompressedSize];
            int decompressedLength = decompressor.decompress(compressed, restored);
            if (decompressedLength != sectionDecompressedSize) {
                throw new Exception("Decompression failure. Expected vs. actual decompressed sizes mismatch: " + sectionDecompressedSize + " / " + decompressedLength);
            }
            byte[] byArray = restored;
            return byArray;
        }
    }

    private byte[] duplicateSection(SegmentHeader segmentHeader, int offset) throws Exception {
        int size = segmentHeader.getSize();
        byte[] content = new byte[size];
        try (BufferedInputStream stream = this.producer.produce();){
            if ((long)offset != stream.skip(offset)) {
                throw new Exception("Failed to skip header bytes");
            }
            int blockSize = Math.min(size, 512);
            long i = 0L;
            byte[] block = new byte[blockSize];
            while (true) {
                int actuallyRead;
                if ((actuallyRead = stream.read(block)) != blockSize) {
                    throw new Exception("Read failure. Block Size: " + blockSize + ", actuallyRead: " + actuallyRead);
                }
                System.arraycopy(block, 0, content, (int)i, blockSize);
                if ((i += (long)blockSize) + (long)blockSize <= (long)size) continue;
                blockSize = (int)((long)size - i);
                if (blockSize == 0) {
                    break;
                }
                block = new byte[blockSize];
            }
        }
        return content;
    }

    private void makeHeader() {
        this.textFileOffsetNew = this.kip1Header.getTextSegmentHeader().getMemoryOffset();
        this.roDataFileOffsetNew = this.kip1Header.getRoDataSegmentHeader().getMemoryOffset();
        int rwDataFileOffsetNew = this.kip1Header.getRwDataSegmentHeader().getMemoryOffset();
        byte flags = this.kip1Header.getFlags();
        flags = (byte)(flags & 0xFFFFFFF8);
        ByteBuffer resultingHeader = ByteBuffer.allocate(256).order(ByteOrder.LITTLE_ENDIAN);
        resultingHeader.put("KIP1".getBytes(StandardCharsets.US_ASCII)).put(this.kip1Header.getName().getBytes(StandardCharsets.US_ASCII));
        resultingHeader.position(16);
        resultingHeader.put(this.kip1Header.getProgramId()).putInt(this.kip1Header.getVersion()).put(this.kip1Header.getMainThreadPriority()).put(this.kip1Header.getMainThreadCoreNumber()).put(this.kip1Header.getReserved1()).put(flags).putInt(this.kip1Header.getTextSegmentHeader().getSegmentOffset()).putInt(this.textFileOffsetNew).putInt(this.textFileOffsetNew).putInt(this.kip1Header.getThreadAffinityMask()).putInt(this.kip1Header.getRoDataSegmentHeader().getSegmentOffset()).putInt(this.roDataFileOffsetNew).putInt(this.roDataFileOffsetNew).putInt(this.kip1Header.getMainThreadStackSize()).putInt(this.kip1Header.getRwDataSegmentHeader().getSegmentOffset()).putInt(rwDataFileOffsetNew).putInt(rwDataFileOffsetNew).put(this.kip1Header.getReserved2()).putInt(this.kip1Header.getBssSegmentHeader().getSegmentOffset()).putInt(this.kip1Header.getBssSegmentHeader().getMemoryOffset()).putInt(this.kip1Header.getBssSegmentHeader().getSize()).put(this.kip1Header.getReserved3()).put(this.kip1Header.getKernelCapabilityData().getRaw());
        this.header = resultingHeader.array();
    }

    private void writeFile(String saveToLocation) throws Exception {
        File location = new File(saveToLocation);
        location.mkdirs();
        try (RandomAccessFile raf = new RandomAccessFile(saveToLocation + File.separator + this.kip1Header.getName() + DECOMPRESSED_FILE_POSTFIX + ".kip1", "rw");){
            raf.write(this.header);
            raf.seek(256L);
            raf.write(this._textDecompressedSection);
            raf.seek(256 + this.textFileOffsetNew);
            raf.write(this._roDataDecompressedSection);
            raf.seek(256 + this.textFileOffsetNew + this.roDataFileOffsetNew);
            raf.write(this._rwDataDecompressedSection);
        }
    }
}

