/*
 * Decompiled with CFR 0.152.
 */
package nsusbloader.Controllers;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javafx.beans.binding.Bindings;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.CheckBoxTableCell;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.scene.input.MouseButton;
import nsusbloader.Controllers.GamesController;
import nsusbloader.Controllers.NSLRowModel;
import nsusbloader.MediatorControl;
import nsusbloader.NSLDataTypes.EFileStatus;

public class NSTableViewController
implements Initializable {
    @FXML
    private TableView<NSLRowModel> table;
    private ObservableList<NSLRowModel> rowsObsLst;
    private GamesController gamesController;

    @Override
    public void initialize(URL url, ResourceBundle resourceBundle) {
        this.rowsObsLst = FXCollections.observableArrayList();
        this.table.setPlaceholder(new Label());
        this.table.setEditable(false);
        this.table.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.table.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        this.table.setOnKeyPressed(keyEvent -> {
            if (!this.rowsObsLst.isEmpty()) {
                if (keyEvent.getCode() == KeyCode.DELETE && !MediatorControl.INSTANCE.getTransferActive()) {
                    this.rowsObsLst.removeAll(this.table.getSelectionModel().getSelectedItems());
                    if (this.rowsObsLst.isEmpty()) {
                        this.gamesController.disableUploadStopBtn(true);
                    }
                    this.table.refresh();
                } else if (keyEvent.getCode() == KeyCode.SPACE) {
                    Iterator i$ = this.table.getSelectionModel().getSelectedItems().iterator();
                    while (i$.hasNext()) {
                        NSLRowModel item;
                        item.setMarkForUpload(!(item = (NSLRowModel)i$.next()).isMarkForUpload());
                    }
                    this.table.refresh();
                }
            }
            keyEvent.consume();
        });
        TableColumn statusColumn = new TableColumn(resourceBundle.getString("tab1_table_Lbl_Status"));
        TableColumn fileNameColumn = new TableColumn(resourceBundle.getString("tab1_table_Lbl_FileName"));
        TableColumn fileSizeColumn = new TableColumn(resourceBundle.getString("tab1_table_Lbl_Size"));
        TableColumn uploadColumn = new TableColumn(resourceBundle.getString("tab1_table_Lbl_Upload"));
        statusColumn.setEditable(false);
        fileNameColumn.setEditable(false);
        fileSizeColumn.setEditable(false);
        uploadColumn.setEditable(true);
        statusColumn.setMinWidth(100.0);
        statusColumn.setPrefWidth(100.0);
        statusColumn.setMaxWidth(100.0);
        statusColumn.setResizable(false);
        fileNameColumn.setMinWidth(25.0);
        fileSizeColumn.setMinWidth(120.0);
        fileSizeColumn.setPrefWidth(120.0);
        fileSizeColumn.setMaxWidth(120.0);
        fileSizeColumn.setResizable(false);
        uploadColumn.setMinWidth(100.0);
        uploadColumn.setPrefWidth(100.0);
        uploadColumn.setMaxWidth(100.0);
        uploadColumn.setResizable(false);
        statusColumn.setCellValueFactory(new PropertyValueFactory("status"));
        fileNameColumn.setCellValueFactory(new PropertyValueFactory("nspFileName"));
        fileSizeColumn.setCellValueFactory(new PropertyValueFactory("nspFileSize"));
        uploadColumn.setCellValueFactory(paramFeatures -> {
            NSLRowModel model = (NSLRowModel)paramFeatures.getValue();
            SimpleBooleanProperty booleanProperty = new SimpleBooleanProperty(model.isMarkForUpload());
            booleanProperty.addListener((ChangeListener<? super Boolean>)((ChangeListener<Boolean>)(observableValue, oldValue, newValue) -> model.setMarkForUpload((boolean)newValue)));
            return booleanProperty;
        });
        uploadColumn.setCellFactory(paramFeatures -> new CheckBoxTableCell());
        fileSizeColumn.setCellFactory(col -> new TableCell<NSLRowModel, Long>(){

            @Override
            protected void updateItem(Long length, boolean empty) {
                if (length == null || empty) {
                    this.setText("");
                } else {
                    this.setText(NSTableViewController.this.formatByteSize(length.longValue()));
                }
            }
        });
        this.table.setRowFactory(nslRowModelTableView -> {
            TableRow row = new TableRow();
            ContextMenu contextMenu = new ContextMenu();
            MenuItem deleteMenuItem = new MenuItem(resourceBundle.getString("tab1_table_contextMenu_Btn_BtnDelete"));
            deleteMenuItem.setOnAction(actionEvent -> {
                this.rowsObsLst.remove(row.getItem());
                if (this.rowsObsLst.isEmpty()) {
                    this.gamesController.disableUploadStopBtn(true);
                }
                this.table.refresh();
            });
            MenuItem deleteAllMenuItem = new MenuItem(resourceBundle.getString("tab1_table_contextMenu_Btn_DeleteAll"));
            deleteAllMenuItem.setOnAction(actionEvent -> {
                this.rowsObsLst.clear();
                this.gamesController.disableUploadStopBtn(true);
                this.table.refresh();
            });
            MenuItem selectAllMenuItem = new MenuItem(resourceBundle.getString("tab1_table_contextMenu_Btn_SelectAll"));
            selectAllMenuItem.setOnAction(actionEvent -> {
                for (NSLRowModel model : this.rowsObsLst) {
                    model.setMarkForUpload(true);
                }
                this.table.refresh();
            });
            MenuItem deselectAllMenuItem = new MenuItem(resourceBundle.getString("tab1_table_contextMenu_Btn_DeselectAll"));
            deselectAllMenuItem.setOnAction(actionEvent -> {
                for (NSLRowModel model : this.rowsObsLst) {
                    model.setMarkForUpload(false);
                }
                this.table.refresh();
            });
            contextMenu.getItems().addAll((MenuItem[])new MenuItem[]{deleteMenuItem, deleteAllMenuItem, selectAllMenuItem, deselectAllMenuItem});
            row.setContextMenu(contextMenu);
            row.contextMenuProperty().bind(Bindings.when(Bindings.isNotNull(row.itemProperty())).then(MediatorControl.INSTANCE.getTransferActive() ? null : contextMenu).otherwise((ContextMenu)null));
            row.setOnMouseClicked(mouseEvent -> {
                if (!row.isEmpty() && mouseEvent.getButton() == MouseButton.PRIMARY) {
                    NSLRowModel thisItem;
                    thisItem.setMarkForUpload(!(thisItem = (NSLRowModel)row.getItem()).isMarkForUpload());
                    this.table.refresh();
                }
                mouseEvent.consume();
            });
            return row;
        });
        this.table.setItems(this.rowsObsLst);
        this.table.getColumns().add(statusColumn);
        this.table.getColumns().add(fileNameColumn);
        this.table.getColumns().add(fileSizeColumn);
        this.table.getColumns().add(uploadColumn);
    }

    public void setGamesController(GamesController gamesController) {
        this.gamesController = gamesController;
    }

    public void setFile(File file) {
        if (!this.rowsObsLst.isEmpty()) {
            ArrayList<String> filesAlreayInList = new ArrayList<String>();
            for (NSLRowModel model : this.rowsObsLst) {
                filesAlreayInList.add(model.getNspFileName());
            }
            if (!filesAlreayInList.contains(file.getName())) {
                this.rowsObsLst.add(new NSLRowModel(file, true));
            }
        } else {
            this.rowsObsLst.add(new NSLRowModel(file, true));
            this.gamesController.disableUploadStopBtn(false);
        }
        this.table.refresh();
    }

    public synchronized void setFiles(List<File> newFiles) {
        if (!this.rowsObsLst.isEmpty()) {
            ArrayList<String> filesAlreayInList = new ArrayList<String>();
            for (NSLRowModel model : this.rowsObsLst) {
                filesAlreayInList.add(model.getNspFileName());
            }
            for (File file : newFiles) {
                if (filesAlreayInList.contains(file.getName())) continue;
                this.rowsObsLst.add(new NSLRowModel(file, true));
            }
        } else {
            for (File file : newFiles) {
                this.rowsObsLst.add(new NSLRowModel(file, true));
            }
            this.gamesController.disableUploadStopBtn(false);
        }
        this.table.refresh();
    }

    public List<File> getFilesForUpload() {
        ArrayList<File> files = new ArrayList<File>();
        if (this.rowsObsLst.isEmpty()) {
            return null;
        }
        for (NSLRowModel model : this.rowsObsLst) {
            if (!model.isMarkForUpload()) continue;
            files.add(model.getNspFile());
            model.setStatus(EFileStatus.INDETERMINATE);
        }
        if (!files.isEmpty()) {
            this.table.refresh();
            return files;
        }
        return null;
    }

    public boolean isFilesForUploadListEmpty() {
        return this.rowsObsLst.isEmpty();
    }

    public void setFileStatus(String fileName, EFileStatus status) {
        for (NSLRowModel model : this.rowsObsLst) {
            if (!model.getNspFileName().equals(fileName)) continue;
            model.setStatus(status);
        }
        this.table.refresh();
    }

    public void setNewProtocol(String newProtocol) {
        if (this.rowsObsLst.isEmpty()) {
            return;
        }
        if (newProtocol.equals("GoldLeaf")) {
            this.rowsObsLst.removeIf(current -> current.getNspFileName().toLowerCase().endsWith("xci") || current.getNspFileName().toLowerCase().endsWith("nsz") || current.getNspFileName().toLowerCase().endsWith("xcz"));
        } else {
            this.rowsObsLst.removeIf(current -> !current.getNspFileName().toLowerCase().endsWith("nsp") || !current.getNspFileName().toLowerCase().endsWith("nsz") || !current.getNspFileName().toLowerCase().endsWith("xci") || !current.getNspFileName().toLowerCase().endsWith("xcz"));
        }
        this.table.refresh();
    }

    private String formatByteSize(double length) {
        int i;
        String[] unitNames = new String[]{"bytes", "KiB", "MiB", "GiB", "TiB"};
        for (i = 0; length > 1024.0 && i < unitNames.length - 1; length /= 1024.0, ++i) {
        }
        return String.format("%,.2f %s", length, unitNames[i]);
    }
}

