/*
 * Decompiled with CFR 0.152.
 */
package nsusbloader.Controllers;

import java.io.File;
import java.net.URL;
import java.util.List;
import java.util.ResourceBundle;
import javafx.beans.binding.Bindings;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.input.DragEvent;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.stage.DirectoryChooser;
import javafx.stage.FileChooser;
import nsusbloader.AppPreferences;
import nsusbloader.Controllers.BlockListViewController;
import nsusbloader.Controllers.ISubscriber;
import nsusbloader.Controllers.Payload;
import nsusbloader.FilesHelper;
import nsusbloader.MediatorControl;
import nsusbloader.NSLDataTypes.EModule;
import nsusbloader.ServiceWindow;
import nsusbloader.Utilities.splitmerge.SplitMergeTaskExecutor;

public class SplitMergeController
implements Initializable,
ISubscriber {
    @FXML
    private ToggleGroup splitMergeTogGrp;
    @FXML
    private VBox smToolPane;
    @FXML
    private RadioButton splitRad;
    @FXML
    private RadioButton mergeRad;
    @FXML
    private Button selectFileFolderBtn;
    @FXML
    private Button changeSaveToBtn;
    @FXML
    private Button convertBtn;
    @FXML
    private Label saveToPathLbl;
    @FXML
    private Label statusLbl;
    @FXML
    private BlockListViewController BlockListViewController;
    private ResourceBundle resourceBundle;
    private Region convertRegion;
    private Thread smThread;
    private Runnable smTask;

    @Override
    public void initialize(URL url, ResourceBundle resourceBundle) {
        this.resourceBundle = resourceBundle;
        this.convertRegion = new Region();
        this.convertBtn.setGraphic(this.convertRegion);
        this.convertBtn.disableProperty().bind(Bindings.isEmpty(this.BlockListViewController.getItems()));
        this.splitRad.setOnAction(actionEvent -> {
            this.statusLbl.setText("");
            this.convertRegion.getStyleClass().clear();
            this.convertRegion.getStyleClass().add("regionSplitToOne");
            this.selectFileFolderBtn.setText(resourceBundle.getString("tabSplMrg_Btn_SelectFile"));
            this.BlockListViewController.clear();
        });
        this.mergeRad.setOnAction(actionEvent -> {
            this.statusLbl.setText("");
            this.convertRegion.getStyleClass().clear();
            this.convertRegion.getStyleClass().add("regionOneToSplit");
            this.selectFileFolderBtn.setText(resourceBundle.getString("tabSplMrg_Btn_SelectFolder"));
            this.BlockListViewController.clear();
        });
        if (AppPreferences.getInstance().getSplitMergeType() == 0) {
            this.splitRad.fire();
        } else {
            this.mergeRad.fire();
        }
        String previouslyUsedSaveToPath = AppPreferences.getInstance().getSplitMergeRecent();
        this.saveToPathLbl.setText(FilesHelper.getRealFolder(previouslyUsedSaveToPath));
        this.changeSaveToBtn.setOnAction(actionEvent -> {
            DirectoryChooser directoryChooser = new DirectoryChooser();
            directoryChooser.setTitle(resourceBundle.getString("tabSplMrg_Btn_SelectFolder"));
            String saveToLocation = FilesHelper.getRealFolder(this.saveToPathLbl.getText());
            directoryChooser.setInitialDirectory(new File(saveToLocation));
            File saveToDir = directoryChooser.showDialog(this.changeSaveToBtn.getScene().getWindow());
            if (saveToDir != null) {
                this.saveToPathLbl.setText(saveToDir.getAbsolutePath());
            }
        });
        this.selectFileFolderBtn.setOnAction(actionEvent -> {
            this.statusLbl.setText("");
            ObservableList<File> alreadyAddedFiles = this.BlockListViewController.getItems();
            if (this.splitRad.isSelected()) {
                FileChooser fc = new FileChooser();
                fc.setTitle(resourceBundle.getString("tabSplMrg_Btn_SelectFile"));
                if (!alreadyAddedFiles.isEmpty()) {
                    String recentLocation = FilesHelper.getRealFolder(((File)alreadyAddedFiles.get(0)).getParentFile().getAbsolutePath());
                    fc.setInitialDirectory(new File(recentLocation));
                } else {
                    fc.setInitialDirectory(new File(System.getProperty("user.home")));
                }
                List<File> files = fc.showOpenMultipleDialog(this.changeSaveToBtn.getScene().getWindow());
                if (files == null || files.isEmpty()) {
                    return;
                }
                this.BlockListViewController.addAll(files);
            } else {
                DirectoryChooser dc = new DirectoryChooser();
                dc.setTitle(resourceBundle.getString("tabSplMrg_Btn_SelectFolder"));
                if (!alreadyAddedFiles.isEmpty()) {
                    String recentLocation = FilesHelper.getRealFolder(((File)alreadyAddedFiles.get(0)).getParentFile().getAbsolutePath());
                    dc.setInitialDirectory(new File(recentLocation));
                } else {
                    dc.setInitialDirectory(new File(System.getProperty("user.home")));
                }
                File folderFile = dc.showDialog(this.changeSaveToBtn.getScene().getWindow());
                if (folderFile == null) {
                    return;
                }
                this.BlockListViewController.add(folderFile);
            }
        });
        this.convertBtn.setOnAction(actionEvent -> this.setConvertBtnAction());
    }

    private void stopBtnAction() {
        if (this.smThread != null && this.smThread.isAlive()) {
            this.smThread.interrupt();
        }
    }

    private void setConvertBtnAction() {
        if (MediatorControl.INSTANCE.getTransferActive()) {
            ServiceWindow.getErrorNotification(this.resourceBundle.getString("windowTitleError"), this.resourceBundle.getString("windowBodyPleaseFinishTransfersFirst"));
            return;
        }
        this.smTask = this.splitRad.isSelected() ? new SplitMergeTaskExecutor(true, this.BlockListViewController.getItems(), this.saveToPathLbl.getText()) : new SplitMergeTaskExecutor(false, this.BlockListViewController.getItems(), this.saveToPathLbl.getText());
        this.smThread = new Thread(this.smTask);
        this.smThread.setDaemon(true);
        this.smThread.start();
    }

    @FXML
    private void handleDragOver(DragEvent event) {
        if (event.getDragboard().hasFiles() && !MediatorControl.INSTANCE.getTransferActive()) {
            event.acceptTransferModes(TransferMode.ANY);
        }
        event.consume();
    }

    @FXML
    private void handleDrop(DragEvent event) {
        List<File> files = event.getDragboard().getFiles();
        File firstFile = files.get(0);
        if (firstFile.isDirectory()) {
            this.mergeRad.fire();
        } else {
            this.splitRad.fire();
        }
        this.BlockListViewController.addAll(files);
        event.setDropCompleted(true);
        event.consume();
    }

    public void updatePreferencesOnExit() {
        if (this.splitRad.isSelected()) {
            AppPreferences.getInstance().setSplitMergeType(0);
        } else {
            AppPreferences.getInstance().setSplitMergeType(1);
        }
        AppPreferences.getInstance().setSplitMergeRecent(this.saveToPathLbl.getText());
    }

    @Override
    public void notify(EModule type, boolean isActive, Payload payload) {
        if (!type.equals((Object)EModule.SPLIT_MERGE_TOOL)) {
            this.smToolPane.setDisable(isActive);
            return;
        }
        this.statusLbl.setText(payload.getMessage());
        if (isActive) {
            this.splitRad.setDisable(true);
            this.mergeRad.setDisable(true);
            this.selectFileFolderBtn.setDisable(true);
            this.changeSaveToBtn.setDisable(true);
            this.convertBtn.setOnAction(e -> this.stopBtnAction());
            this.convertBtn.setText(this.resourceBundle.getString("btn_Stop"));
            this.convertRegion.getStyleClass().clear();
            this.convertRegion.getStyleClass().add("regionStop");
            this.convertBtn.getStyleClass().remove("buttonUp");
            this.convertBtn.getStyleClass().add("buttonStop");
            return;
        }
        this.splitRad.setDisable(false);
        this.mergeRad.setDisable(false);
        this.selectFileFolderBtn.setDisable(false);
        this.changeSaveToBtn.setDisable(false);
        this.convertBtn.setOnAction(e -> this.setConvertBtnAction());
        this.convertBtn.setText(this.resourceBundle.getString("tabSplMrg_Btn_Convert"));
        this.convertRegion.getStyleClass().clear();
        this.convertBtn.getStyleClass().remove("buttonStop");
        this.convertBtn.getStyleClass().add("buttonUp");
        if (this.splitRad.isSelected()) {
            this.convertRegion.getStyleClass().add("regionSplitToOne");
        } else {
            this.convertRegion.getStyleClass().add("regionOneToSplit");
        }
    }
}

