/*
 * Decompiled with CFR 0.152.
 */
package nsusbloader.com.usb.common;

import nsusbloader.com.usb.common.NsUsbEndpointDescriptor;
import nsusbloader.com.usb.common.NsUsbEndpointDescriptorUtils;
import org.usb4java.InterfaceDescriptor;

public class NsUsbInterfaceDescriptor {
    private final byte bLength;
    private final byte bDescriptorType;
    private final byte bInterfaceNumber;
    private final byte bAlternateSetting;
    private final byte bNumEndpoints;
    private final byte bInterfaceClass;
    private final byte bInterfaceSubClass;
    private final byte bInterfaceProtocol;
    private final byte iInterface;
    private final NsUsbEndpointDescriptor[] endpointDescriptors;

    NsUsbInterfaceDescriptor(InterfaceDescriptor interfaceDescriptor) {
        this.bLength = interfaceDescriptor.bLength();
        this.bDescriptorType = interfaceDescriptor.bDescriptorType();
        this.bInterfaceNumber = interfaceDescriptor.bInterfaceNumber();
        this.bAlternateSetting = interfaceDescriptor.bAlternateSetting();
        this.bNumEndpoints = interfaceDescriptor.bNumEndpoints();
        this.bInterfaceClass = interfaceDescriptor.bInterfaceClass();
        this.bInterfaceSubClass = interfaceDescriptor.bInterfaceSubClass();
        this.bInterfaceProtocol = interfaceDescriptor.bInterfaceProtocol();
        this.iInterface = interfaceDescriptor.iInterface();
        this.endpointDescriptors = NsUsbEndpointDescriptorUtils.convertFromNatives(interfaceDescriptor.endpoint());
    }

    public byte getbLength() {
        return this.bLength;
    }

    public byte getbDescriptorType() {
        return this.bDescriptorType;
    }

    public byte getbInterfaceNumber() {
        return this.bInterfaceNumber;
    }

    public byte getbAlternateSetting() {
        return this.bAlternateSetting;
    }

    public byte getbNumEndpoints() {
        return this.bNumEndpoints;
    }

    public byte getbInterfaceClass() {
        return this.bInterfaceClass;
    }

    public byte getbInterfaceSubClass() {
        return this.bInterfaceSubClass;
    }

    public byte getbInterfaceProtocol() {
        return this.bInterfaceProtocol;
    }

    public byte getiInterface() {
        return this.iInterface;
    }

    public NsUsbEndpointDescriptor[] getEndpointDescriptors() {
        return this.endpointDescriptors;
    }
}

