/*
 * Decompiled with CFR 0.152.
 */
package libKonogonka.fs.NCA;

import java.util.Arrays;
import libKonogonka.Converter;

public class NCAHeaderTableEntry {
    private final long mediaStartOffset;
    private final long mediaEndOffset;
    private final byte[] unknwn1;
    private final byte[] unknwn2;

    public NCAHeaderTableEntry(byte[] table) throws Exception {
        if (table.length < 16) {
            throw new Exception("Section Table size is too small.");
        }
        this.mediaStartOffset = Converter.getLElongOfInt(table, 0);
        this.mediaEndOffset = Converter.getLElongOfInt(table, 4);
        this.unknwn1 = Arrays.copyOfRange(table, 8, 12);
        this.unknwn2 = Arrays.copyOfRange(table, 12, 16);
    }

    public long getMediaStartOffset() {
        return this.mediaStartOffset;
    }

    public long getMediaEndOffset() {
        return this.mediaEndOffset;
    }

    public byte[] getUnknwn1() {
        return this.unknwn1;
    }

    public byte[] getUnknwn2() {
        return this.unknwn2;
    }
}

