/*
 * Decompiled with CFR 0.152.
 */
package nsusbloader.Controllers;

import java.io.File;
import java.net.URL;
import java.util.List;
import java.util.ResourceBundle;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.MenuItem;

public class BlockListViewController
implements Initializable {
    @FXML
    private ListView<File> splitMergeListView;
    private ObservableList<File> filesList;
    private ResourceBundle resourceBundle;

    @Override
    public void initialize(URL url, ResourceBundle resourceBundle) {
        this.resourceBundle = resourceBundle;
        this.setFilesListView();
        this.filesList = this.splitMergeListView.getItems();
    }

    private void setFilesListView() {
        this.splitMergeListView.setCellFactory(fileListView -> {
            FileListCell item = new FileListCell();
            this.setContextMenuToItem(item);
            return item;
        });
    }

    private <T> void setContextMenuToItem(ListCell<T> item) {
        ContextMenu contextMenu = new ContextMenu();
        MenuItem deleteMenuItem = new MenuItem(this.resourceBundle.getString("tab1_table_contextMenu_Btn_BtnDelete"));
        deleteMenuItem.setOnAction(actionEvent -> {
            this.filesList.remove(item.getItem());
            this.splitMergeListView.refresh();
        });
        MenuItem deleteAllMenuItem = new MenuItem(this.resourceBundle.getString("tab1_table_contextMenu_Btn_DeleteAll"));
        deleteAllMenuItem.setOnAction(actionEvent -> {
            this.filesList.clear();
            this.splitMergeListView.refresh();
        });
        contextMenu.getItems().addAll((MenuItem[])new MenuItem[]{deleteMenuItem, deleteAllMenuItem});
        item.setContextMenu(contextMenu);
    }

    public void add(File file) {
        if (this.filesList.contains(file)) {
            return;
        }
        this.filesList.add(file);
    }

    public void addAll(List<File> files) {
        for (File file : files) {
            this.add(file);
        }
    }

    public ObservableList<File> getItems() {
        return this.filesList;
    }

    public void clear() {
        this.filesList.clear();
        this.splitMergeListView.refresh();
    }

    private static class FileListCell
    extends ListCell<File> {
        private FileListCell() {
        }

        @Override
        public void updateItem(File file, boolean isEmpty) {
            super.updateItem(file, isEmpty);
            if (file == null || isEmpty) {
                this.setText(null);
                return;
            }
            String fileName = file.getName();
            this.setText(fileName);
        }
    }
}

