/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.layout;

import com.sun.javafx.UnmodifiableArrayList;
import com.sun.javafx.css.SubCssMetaData;
import com.sun.javafx.scene.layout.region.BorderImageSlices;
import com.sun.javafx.scene.layout.region.BorderImageWidthConverter;
import com.sun.javafx.scene.layout.region.CornerRadiiConverter;
import com.sun.javafx.scene.layout.region.LayeredBorderPaintConverter;
import com.sun.javafx.scene.layout.region.LayeredBorderStyleConverter;
import com.sun.javafx.scene.layout.region.Margins;
import com.sun.javafx.scene.layout.region.RepeatStruct;
import com.sun.javafx.scene.layout.region.RepeatStructConverter;
import com.sun.javafx.scene.layout.region.SliceSequenceConverter;
import com.sun.javafx.util.InterpolationUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javafx.animation.Interpolatable;
import javafx.beans.NamedArg;
import javafx.css.CssMetaData;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.converter.InsetsConverter;
import javafx.css.converter.URLConverter;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.layout.BackgroundRepeat;
import javafx.scene.layout.BorderImage;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.paint.Paint;

public final class Border
implements Interpolatable<Border> {
    static final CssMetaData<Node, Paint[]> BORDER_COLOR = new SubCssMetaData<Paint[]>("-fx-border-color", (StyleConverter)LayeredBorderPaintConverter.getInstance());
    static final CssMetaData<Node, BorderStrokeStyle[][]> BORDER_STYLE = new SubCssMetaData<BorderStrokeStyle[][]>("-fx-border-style", (StyleConverter)LayeredBorderStyleConverter.getInstance());
    static final CssMetaData<Node, Margins[]> BORDER_WIDTH = new SubCssMetaData<Margins[]>("-fx-border-width", (StyleConverter)Margins.SequenceConverter.getInstance());
    static final CssMetaData<Node, CornerRadii[]> BORDER_RADIUS = new SubCssMetaData<CornerRadii[]>("-fx-border-radius", (StyleConverter)CornerRadiiConverter.getInstance());
    static final CssMetaData<Node, Insets[]> BORDER_INSETS = new SubCssMetaData<Insets[]>("-fx-border-insets", (StyleConverter)InsetsConverter.SequenceConverter.getInstance());
    static final CssMetaData<Node, String[]> BORDER_IMAGE_SOURCE = new SubCssMetaData<String[]>("-fx-border-image-source", (StyleConverter)URLConverter.SequenceConverter.getInstance());
    static final CssMetaData<Node, RepeatStruct[]> BORDER_IMAGE_REPEAT = new SubCssMetaData<RepeatStruct[]>("-fx-border-image-repeat", (StyleConverter)RepeatStructConverter.getInstance(), new RepeatStruct[]{new RepeatStruct(BackgroundRepeat.REPEAT, BackgroundRepeat.REPEAT)});
    static final CssMetaData<Node, BorderImageSlices[]> BORDER_IMAGE_SLICE = new SubCssMetaData<BorderImageSlices[]>("-fx-border-image-slice", (StyleConverter)SliceSequenceConverter.getInstance(), new BorderImageSlices[]{BorderImageSlices.DEFAULT});
    static final CssMetaData<Node, BorderWidths[]> BORDER_IMAGE_WIDTH = new SubCssMetaData<BorderWidths[]>("-fx-border-image-width", (StyleConverter)BorderImageWidthConverter.getInstance(), new BorderWidths[]{BorderWidths.DEFAULT});
    static final CssMetaData<Node, Insets[]> BORDER_IMAGE_INSETS = new SubCssMetaData<Insets[]>("-fx-border-image-insets", (StyleConverter)InsetsConverter.SequenceConverter.getInstance(), new Insets[]{Insets.EMPTY});
    private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES = Collections.unmodifiableList(Arrays.asList(BORDER_COLOR, BORDER_STYLE, BORDER_WIDTH, BORDER_RADIUS, BORDER_INSETS, BORDER_IMAGE_SOURCE, BORDER_IMAGE_REPEAT, BORDER_IMAGE_SLICE, BORDER_IMAGE_WIDTH, BORDER_IMAGE_INSETS));
    public static final Border EMPTY = new Border((BorderStroke[])null, null);
    private final List<BorderStroke> strokes;
    private final List<BorderImage> images;
    private final Insets outsets;
    private final Insets insets;
    private final int hash;

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return STYLEABLES;
    }

    public final List<BorderStroke> getStrokes() {
        return this.strokes;
    }

    public final List<BorderImage> getImages() {
        return this.images;
    }

    public final Insets getOutsets() {
        return this.outsets;
    }

    public final Insets getInsets() {
        return this.insets;
    }

    public final boolean isEmpty() {
        return this.strokes.isEmpty() && this.images.isEmpty();
    }

    public Border(BorderStroke ... borderStrokeArray) {
        this(borderStrokeArray, (BorderImage[])null);
    }

    public Border(BorderImage ... borderImageArray) {
        this((BorderStroke[])null, borderImageArray);
    }

    public Border(@NamedArg(value="strokes") List<BorderStroke> list, @NamedArg(value="images") List<BorderImage> list2) {
        this(list != null ? UnmodifiableArrayList.copyOfNullFiltered(list) : List.of(), list2 != null ? UnmodifiableArrayList.copyOfNullFiltered(list2) : List.of(), 0);
    }

    public Border(@NamedArg(value="strokes") BorderStroke[] borderStrokeArray, @NamedArg(value="images") BorderImage[] borderImageArray) {
        this(borderStrokeArray != null ? UnmodifiableArrayList.copyOfNullFiltered(borderStrokeArray) : List.of(), borderImageArray != null ? UnmodifiableArrayList.copyOfNullFiltered(borderImageArray) : List.of(), 0);
    }

    private Border(List<BorderStroke> list, List<BorderImage> list2, int n) {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        double d7;
        double d8;
        Interpolatable<BorderStroke> interpolatable;
        int n2;
        Objects.requireNonNull(list, "strokes cannot be null");
        Objects.requireNonNull(list2, "images cannot be null");
        double d9 = 0.0;
        double d10 = 0.0;
        double d11 = 0.0;
        double d12 = 0.0;
        double d13 = 0.0;
        double d14 = 0.0;
        double d15 = 0.0;
        double d16 = 0.0;
        int n3 = list.size();
        for (n2 = 0; n2 < n3; ++n2) {
            interpolatable = list.get(n2);
            d8 = interpolatable.innerEdge.getTop();
            d7 = interpolatable.innerEdge.getRight();
            d6 = interpolatable.innerEdge.getBottom();
            d5 = interpolatable.innerEdge.getLeft();
            d9 = d9 >= d8 ? d9 : d8;
            d10 = d10 >= d7 ? d10 : d7;
            d11 = d11 >= d6 ? d11 : d6;
            d12 = d12 >= d5 ? d12 : d5;
            d4 = interpolatable.outerEdge.getTop();
            d3 = interpolatable.outerEdge.getRight();
            d2 = interpolatable.outerEdge.getBottom();
            d = interpolatable.outerEdge.getLeft();
            d13 = d13 >= d4 ? d13 : d4;
            d14 = d14 >= d3 ? d14 : d3;
            d15 = d15 >= d2 ? d15 : d2;
            d16 = d16 >= d ? d16 : d;
        }
        this.strokes = list;
        n3 = list2.size();
        for (n2 = 0; n2 < n3; ++n2) {
            interpolatable = list2.get(n2);
            d8 = ((BorderImage)interpolatable).innerEdge.getTop();
            d7 = ((BorderImage)interpolatable).innerEdge.getRight();
            d6 = ((BorderImage)interpolatable).innerEdge.getBottom();
            d5 = ((BorderImage)interpolatable).innerEdge.getLeft();
            d9 = d9 >= d8 ? d9 : d8;
            d10 = d10 >= d7 ? d10 : d7;
            d11 = d11 >= d6 ? d11 : d6;
            d12 = d12 >= d5 ? d12 : d5;
            d4 = ((BorderImage)interpolatable).outerEdge.getTop();
            d3 = ((BorderImage)interpolatable).outerEdge.getRight();
            d2 = ((BorderImage)interpolatable).outerEdge.getBottom();
            d = ((BorderImage)interpolatable).outerEdge.getLeft();
            d13 = d13 >= d4 ? d13 : d4;
            d14 = d14 >= d3 ? d14 : d3;
            d15 = d15 >= d2 ? d15 : d2;
            d16 = d16 >= d ? d16 : d;
        }
        this.images = list2;
        this.outsets = new Insets(d13, d14, d15, d16);
        this.insets = new Insets(d9, d10, d11, d12);
        n2 = this.strokes.hashCode();
        this.hash = n2 = 31 * n2 + this.images.hashCode();
    }

    public static Border stroke(Paint paint) {
        return new Border(new BorderStroke(paint, BorderStrokeStyle.SOLID, null, null));
    }

    @Override
    public Border interpolate(Border border, double d) {
        List<BorderStroke> list;
        Objects.requireNonNull(border, "endValue cannot be null");
        if (d <= 0.0) {
            return this;
        }
        if (d >= 1.0) {
            return border;
        }
        List<BorderImage> list2 = this.images == border.images ? this.images : InterpolationUtils.interpolateListsPairwise(this.images, border.images, d);
        List<BorderStroke> list3 = list = this.strokes == border.strokes ? this.strokes : InterpolationUtils.interpolateListsPairwise(this.strokes, border.strokes, d);
        if (this.images == list2 && this.strokes == list) {
            return this;
        }
        if (border.images == list2 && border.strokes == list) {
            return border;
        }
        return new Border(list, list2);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Border border = (Border)object;
        if (this.hash != border.hash) {
            return false;
        }
        if (!this.images.equals(border.images)) {
            return false;
        }
        return this.strokes.equals(border.strokes);
    }

    public int hashCode() {
        return this.hash;
    }
}

