/*
 * Decompiled with CFR 0.152.
 */
package libKonogonka.fs.other.System2.ini1;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import libKonogonka.aesctr.InFileStreamClassicProducer;
import libKonogonka.fs.ExportAble;
import libKonogonka.fs.other.System2.System2Header;
import libKonogonka.fs.other.System2.ini1.Ini1Header;
import libKonogonka.fs.other.System2.ini1.KIP1Header;
import libKonogonka.fs.other.System2.ini1.KIP1Provider;

public class Ini1Provider
extends ExportAble {
    private Ini1Header ini1Header;
    private List<KIP1Provider> kip1List;
    private final InFileStreamClassicProducer producer;

    public Ini1Provider(Path fileLocation) throws Exception {
        this.producer = new InFileStreamClassicProducer(fileLocation);
        this.stream = this.producer.produce();
        this.makeHeader();
        this.collectKips();
        this.stream.close();
    }

    public Ini1Provider(InFileStreamClassicProducer producer) throws Exception {
        this.producer = producer;
        this.stream = producer.produce();
        this.makeHeader();
        this.collectKips();
        this.stream.close();
    }

    public Ini1Provider(System2Header system2Header, String pathToFile, int kernelMapIni1Offset) throws Exception {
        Path filePath = Paths.get(pathToFile, new String[0]);
        this.producer = new InFileStreamClassicProducer(filePath, (long)(512 + kernelMapIni1Offset), 512L, Files.size(filePath), system2Header.getKey(), system2Header.getSection0Ctr());
        this.stream = this.producer.produce();
        this.makeHeader();
        this.collectKips();
        this.stream.close();
    }

    private void makeHeader() throws Exception {
        byte[] headerBytes = new byte[16];
        if (16 != this.stream.read(headerBytes)) {
            throw new Exception("Unable to read header bytes");
        }
        this.ini1Header = new Ini1Header(headerBytes);
    }

    private void collectKips() throws Exception {
        this.kip1List = new ArrayList<KIP1Provider>();
        long skipTillNextKip1 = 0L;
        long kip1StartOffset = 0L;
        for (int i = 0; i < this.ini1Header.getKipNumber(); ++i) {
            this.skipLoop(skipTillNextKip1);
            byte[] kip1bytes = new byte[256];
            if (256 != this.stream.read(kip1bytes)) {
                throw new Exception("Unable to read KIP1 data ");
            }
            KIP1Provider kip1 = new KIP1Provider(kip1bytes, kip1StartOffset, this.producer.getSuccessor(16L, true));
            this.kip1List.add(kip1);
            KIP1Header kip1Header = kip1.getHeader();
            skipTillNextKip1 = kip1Header.getTextSegmentHeader().getSize() + kip1Header.getRoDataSegmentHeader().getSize() + kip1Header.getRwDataSegmentHeader().getSize() + kip1Header.getBssSegmentHeader().getSize();
            kip1StartOffset = kip1.getEndOffset();
        }
    }

    private void skipLoop(long size) throws IOException {
        long mustSkip = size;
        long skipped = 0L;
        while (mustSkip > 0L) {
            mustSkip = size - (skipped += this.stream.skip(mustSkip));
        }
    }

    public Ini1Header getIni1Header() {
        return this.ini1Header;
    }

    public List<KIP1Provider> getKip1List() {
        return this.kip1List;
    }

    public boolean export(String saveTo) throws Exception {
        this.stream = this.producer.produce();
        return this.export(saveTo, "INI1.bin", 0L, this.ini1Header.getSize());
    }
}

