/*
 * Decompiled with CFR 0.152.
 */
package libKonogonka.fs.other.System2;

import java.io.BufferedInputStream;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import libKonogonka.KeyChainHolder;
import libKonogonka.aesctr.InFileStreamClassicProducer;
import libKonogonka.aesctr.InFileStreamProducer;
import libKonogonka.fs.ExportAble;
import libKonogonka.fs.other.System2.KernelMap;
import libKonogonka.fs.other.System2.System2Header;
import libKonogonka.fs.other.System2.ini1.Ini1Provider;

public class System2Provider
extends ExportAble {
    private byte[] rsa2048signature;
    private System2Header header;
    private KernelMap kernelMap;
    private Ini1Provider ini1Provider;
    private final KeyChainHolder keyChainHolder;
    private InFileStreamClassicProducer producer;

    public System2Provider(String pathToFile, KeyChainHolder keyChainHolder) throws Exception {
        this.keyChainHolder = keyChainHolder;
        Path filePath = Paths.get(pathToFile, new String[0]);
        this.stream = new BufferedInputStream(Files.newInputStream(filePath, new OpenOption[0]));
        this.readSignatures();
        this.readHeader();
        this.stream.close();
        this.createProducerOfFile(filePath);
        this.findIni1KernelMap();
        this.stream.close();
    }

    public System2Provider(InFileStreamProducer producer, KeyChainHolder keyChainHolder) throws Exception {
        this.keyChainHolder = keyChainHolder;
        this.stream = producer.produce();
        this.readSignatures();
        this.readHeader();
        this.stream.close();
        this.createProducerOfStream(producer);
        this.findIni1KernelMap();
        this.stream.close();
    }

    private void readSignatures() throws Exception {
        this.rsa2048signature = new byte[256];
        if (256 != this.stream.read(this.rsa2048signature)) {
            throw new Exception("Unable to read System2 RSA-2048 signature bytes");
        }
    }

    private void readHeader() throws Exception {
        byte[] headerBytes = new byte[256];
        if (256 != this.stream.read(headerBytes)) {
            throw new Exception("Unable to read System2 header bytes");
        }
        this.header = new System2Header(headerBytes, this.keyChainHolder.getRawKeySet());
    }

    private void createProducerOfFile(Path filePath) throws Exception {
        this.producer = new InFileStreamClassicProducer(filePath, 0L, 512L, this.header.getPackageSize(), this.header.getKey(), this.header.getSection0Ctr());
        this.stream = this.producer.produce();
    }

    private void createProducerOfStream(InFileStreamProducer parentProducer) throws Exception {
        this.producer = new InFileStreamClassicProducer(parentProducer, 0L, 512L, this.header.getPackageSize(), this.header.getKey(), this.header.getSection0Ctr(), this.header.getPackageSize());
        this.stream = this.producer.produce();
    }

    private void findIni1KernelMap() throws Exception {
        if (512L != this.stream.skip(512L)) {
            throw new Exception("Unable to skip offset of 0x200");
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(4096);
        for (int j = 0; j < 8; ++j) {
            byte[] block = new byte[512];
            int actuallyRead = this.stream.read(block);
            if (actuallyRead != 512) {
                throw new Exception("Read failure " + actuallyRead);
            }
            byteBuffer.put(block);
        }
        byte[] searchField = byteBuffer.array();
        for (int i = 0; i < 1024; i += 4) {
            this.kernelMap = new KernelMap(searchField, i);
            if (!this.kernelMap.isValid(this.header.getSection0size())) continue;
            return;
        }
        throw new Exception("Kernel map not found");
    }

    public boolean exportKernel(String saveTo) throws Exception {
        this.stream = this.producer.produce();
        return this.export(saveTo, "Kernel.bin", 512L, this.header.getSection0size());
    }

    public byte[] getRsa2048signature() {
        return this.rsa2048signature;
    }

    public System2Header getHeader() {
        return this.header;
    }

    public KernelMap getKernelMap() {
        return this.kernelMap;
    }

    public Ini1Provider getIni1Provider() throws Exception {
        if (this.ini1Provider == null) {
            this.ini1Provider = new Ini1Provider(this.producer.getSuccessor(512 + this.kernelMap.getIni1Offset(), true));
        }
        return this.ini1Provider;
    }
}

