/*
 * Decompiled with CFR 0.152.
 */
package nsusbloader.Controllers;

import java.net.URL;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.CheckBox;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.layout.VBox;
import nsusbloader.AppPreferences;
import nsusbloader.ServiceWindow;

public class SettingsBlockTinfoilController
implements Initializable {
    @FXML
    private CheckBox xciNszXczSupportCB;
    @FXML
    private CheckBox validateNSHostNameCB;
    @FXML
    private CheckBox networkExpertModeCB;
    @FXML
    private CheckBox autoDetectIpCB;
    @FXML
    private CheckBox randomlySelectPortCB;
    @FXML
    private CheckBox noRequestsServeCB;
    @FXML
    private VBox networkExpertSettingsVBox;
    @FXML
    private TextField pcIpTF;
    @FXML
    private TextField pcPortTF;
    @FXML
    private TextField pcExtraTF;
    private ResourceBundle resourceBundle;

    @Override
    public void initialize(URL url, ResourceBundle resourceBundle) {
        this.resourceBundle = resourceBundle;
        AppPreferences preferences = AppPreferences.getInstance();
        this.networkExpertSettingsVBox.visibleProperty().bind(this.networkExpertModeCB.selectedProperty());
        this.pcIpTF.disableProperty().bind(this.autoDetectIpCB.selectedProperty());
        this.pcPortTF.disableProperty().bind(this.randomlySelectPortCB.selectedProperty());
        this.pcExtraTF.disableProperty().bind(this.noRequestsServeCB.selectedProperty().not());
        this.xciNszXczSupportCB.setSelected(preferences.getTfXCI());
        this.validateNSHostNameCB.setSelected(preferences.getNsIpValidationNeeded());
        this.networkExpertModeCB.setSelected(preferences.getExpertMode());
        this.pcIpTF.setText(preferences.getHostIp());
        this.pcPortTF.setText(preferences.getHostPort());
        this.pcExtraTF.setText(preferences.getHostExtra());
        this.autoDetectIpCB.setSelected(preferences.getAutoDetectIp());
        this.randomlySelectPortCB.setSelected(preferences.getRandPort());
        boolean noServeRequestsFlag = preferences.getNotServeRequests();
        if (noServeRequestsFlag) {
            this.noServeRequestAction(true);
        }
        this.noRequestsServeCB.setSelected(noServeRequestsFlag);
        this.pcIpTF.setTextFormatter(this.buildSpacelessTextFormatter());
        this.pcPortTF.setTextFormatter(this.buildPortTextFormatter());
        this.pcExtraTF.setTextFormatter(this.buildSpacelessTextFormatter());
        this.autoDetectIpCB.setOnAction(e -> this.pcIpTF.requestFocus());
        this.randomlySelectPortCB.setOnAction(e -> this.pcPortTF.requestFocus());
        this.noRequestsServeCB.selectedProperty().addListener((observableValue, oldValue, newValue) -> this.noServeRequestAction((boolean)newValue));
    }

    private TextFormatter buildSpacelessTextFormatter() {
        return new TextFormatter(change -> {
            String text = change.getControlNewText();
            if (text.contains(" ") || text.contains("\t")) {
                return null;
            }
            return change;
        });
    }

    private TextFormatter buildPortTextFormatter() {
        String PORT_NUMBER_PATTERN = "^[0-9]{0,5}$";
        return new TextFormatter(change -> {
            String text = change.getControlNewText();
            if (text.isEmpty()) {
                return change;
            }
            if (!text.matches("^[0-9]{0,5}$")) {
                return null;
            }
            int newPortNumber = Integer.parseInt(text);
            if (newPortNumber > 65535 || newPortNumber == 0) {
                ServiceWindow.getErrorNotification(this.resourceBundle.getString("windowTitleErrorPort"), this.resourceBundle.getString("windowBodyErrorPort"));
                return null;
            }
            return change;
        });
    }

    private void noServeRequestAction(boolean isNoServe) {
        if (isNoServe) {
            this.autoDetectIpCB.setDisable(true);
            this.autoDetectIpCB.setSelected(false);
            this.randomlySelectPortCB.setDisable(true);
            this.randomlySelectPortCB.setSelected(false);
        } else {
            this.autoDetectIpCB.setDisable(false);
            this.autoDetectIpCB.setSelected(true);
            this.randomlySelectPortCB.setDisable(false);
            this.randomlySelectPortCB.setSelected(true);
        }
    }

    public String getHostIp() {
        return this.pcIpTF.getText();
    }

    public String getHostPort() {
        return this.pcPortTF.getText();
    }

    public String getHostExtra() {
        return this.pcExtraTF.getText();
    }

    public boolean isXciNszXczSupport() {
        return this.xciNszXczSupportCB.isSelected();
    }

    public boolean isExpertModeSelected() {
        return this.networkExpertModeCB.isSelected();
    }

    public boolean isAutoDetectIp() {
        return this.autoDetectIpCB.isSelected();
    }

    public boolean isRandomlySelectPort() {
        return this.randomlySelectPortCB.isSelected();
    }

    public boolean isNoRequestsServe() {
        return this.noRequestsServeCB.isSelected();
    }

    public boolean isValidateNSHostName() {
        return this.validateNSHostNameCB.isSelected();
    }

    void updatePreferencesOnExit() {
        AppPreferences preferences = AppPreferences.getInstance();
        preferences.setNsIpValidationNeeded(this.isValidateNSHostName());
        preferences.setExpertMode(this.isExpertModeSelected());
        preferences.setAutoDetectIp(this.isAutoDetectIp());
        preferences.setRandPort(this.isRandomlySelectPort());
        preferences.setNotServeRequests(this.isNoRequestsServe());
        preferences.setHostIp(this.getHostIp());
        preferences.setHostPort(this.getHostPort());
        preferences.setHostExtra(this.getHostExtra());
        preferences.setTfXCI(this.isXciNszXczSupport());
    }
}

