/*
 * Decompiled with CFR 0.152.
 */
package nsusbloader.Utilities;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import nsusbloader.Utilities.RcmSmash;

public class JNIRcmLoader {
    private JNIRcmLoader() {
    }

    public static boolean load() {
        File libraryFile;
        String libPostfix;
        String osName = System.getProperty("os.name").toLowerCase().replace(" ", "");
        String osArch = System.getProperty("os.arch").toLowerCase().replace(" ", "");
        if (osName.equals("linux")) {
            switch (osArch) {
                case "i386": 
                case "i586": 
                case "i686": {
                    osArch = "x86";
                    break;
                }
                case "x86_64": 
                case "amd64": {
                    osArch = "amd64";
                    break;
                }
                case "arm": {
                    osArch = "arm";
                    break;
                }
                default: {
                    return false;
                }
            }
            libPostfix = "so";
        } else if (osName.contains("windows")) {
            osName = "windows";
            libPostfix = "dll";
            switch (osArch) {
                case "x86": 
                case "i386": 
                case "i586": 
                case "i686": {
                    osArch = "x86";
                    break;
                }
                case "x86_64": 
                case "amd64": {
                    osArch = "amd64";
                    break;
                }
                default: {
                    return false;
                }
            }
        } else {
            return false;
        }
        URL url_ = RcmSmash.class.getResource("/native/" + osName + "/" + osArch + "/smashlib." + libPostfix);
        if (url_ == null) {
            return false;
        }
        String proto = url_.getProtocol();
        if (proto.equals("file")) {
            try {
                libraryFile = new File(url_.toURI());
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
                return false;
            }
        } else if (proto.equals("jar")) {
            InputStream inStream = RcmSmash.class.getResourceAsStream("/native/" + osName + "/" + osArch + "/smashlib." + libPostfix);
            if (inStream == null) {
                return false;
            }
            try {
                File tmpDirFile = File.createTempFile("jni", null);
                if (!tmpDirFile.delete()) {
                    return false;
                }
                if (!tmpDirFile.mkdirs()) {
                    return false;
                }
                libraryFile = new File(tmpDirFile, "smashlib." + libPostfix);
                byte[] ioBuffer = new byte[8192];
                FileOutputStream foStream = new FileOutputStream(libraryFile);
                while (inStream.read(ioBuffer) != -1) {
                    foStream.write(ioBuffer);
                }
                foStream.close();
                inStream.close();
                libraryFile.deleteOnExit();
                tmpDirFile.deleteOnExit();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                return false;
            }
        } else {
            return false;
        }
        System.load(libraryFile.getAbsolutePath());
        return true;
    }
}

