/*
 * Decompiled with CFR 0.152.
 */
package nsusbloader.com.usb;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javafx.application.Platform;
import javafx.stage.FileChooser;
import nsusbloader.MediatorControl;
import nsusbloader.ModelControllers.CancellableRunnable;
import nsusbloader.ModelControllers.ILogPrinter;
import nsusbloader.NSLDataTypes.EMsgType;
import nsusbloader.com.DataConvertUtils;
import nsusbloader.com.helpers.NSSplitReader;
import nsusbloader.com.usb.TransferModule;
import org.usb4java.DeviceHandle;
import org.usb4java.LibUsb;

class GoldLeaf_08
extends TransferModule {
    private static final int PACKET_SIZE = 4096;
    private final boolean nspFilterForGl;
    private final byte[] CMD_GLCO_SUCCESS = new byte[]{71, 76, 67, 79, 0, 0, 0, 0};
    private final byte[] CMD_GLCO_FAILURE = new byte[]{71, 76, 67, 79, 0, 0, -83, -34};
    private final byte[] GL_OBJ_TYPE_FILE = new byte[]{1, 0, 0, 0};
    private final byte[] GL_OBJ_TYPE_DIR = new byte[]{2, 0, 0, 0};
    private String recentPath = null;
    private String[] recentDirs = null;
    private String[] recentFiles = null;
    private final String[] nspMapKeySetIndexes;
    private String openReadFileNameAndPath;
    private RandomAccessFile randAccessFile;
    private NSSplitReader splitReader;
    private final HashMap<String, BufferedOutputStream> writeFilesMap;
    private long virtDriveSize;
    private final HashMap<String, Long> splitFileSize;
    private final boolean isWindows;
    private final String homePath;
    private File selectedFile;
    private final CancellableRunnable task;

    GoldLeaf_08(DeviceHandle handler, LinkedHashMap<String, File> nspMap, CancellableRunnable task, ILogPrinter logPrinter, boolean nspFilter) {
        super(handler, nspMap, task, logPrinter);
        this.task = task;
        boolean CMD_GetDriveCount = true;
        int CMD_GetDriveInfo = 2;
        int CMD_StatPath = 3;
        int CMD_GetFileCount = 4;
        int CMD_GetFile = 5;
        int CMD_GetDirectoryCount = 6;
        int CMD_GetDirectory = 7;
        int CMD_StartFile = 8;
        int CMD_ReadFile = 9;
        int CMD_WriteFile = 10;
        int CMD_EndFile = 11;
        int CMD_Create = 12;
        int CMD_Delete = 13;
        int CMD_Rename = 14;
        int CMD_GetSpecialPathCount = 15;
        int CMD_GetSpecialPath = 16;
        int CMD_SelectFile = 17;
        byte[] CMD_GLCI = new byte[]{71, 76, 67, 73};
        this.nspFilterForGl = nspFilter;
        this.print("=========== GoldLeaf v0.8-0.9 ===========\n\tVIRT:/ equals files added into the application\n\tHOME:/ equals " + System.getProperty("user.home"), EMsgType.INFO);
        this.writeFilesMap = new HashMap();
        int i = 0;
        this.nspMapKeySetIndexes = new String[nspMap.size()];
        for (String fileName : nspMap.keySet()) {
            this.nspMapKeySetIndexes[i++] = fileName;
        }
        this.isWindows = System.getProperty("os.name").contains("Windows");
        this.homePath = System.getProperty("user.home") + File.separator;
        this.splitFileSize = new HashMap();
        for (File nspFile : nspMap.values()) {
            if (nspFile.isDirectory()) {
                File[] subFiles = nspFile.listFiles((file, name) -> name.matches("[0-9]{2}"));
                long size = 0L;
                for (File subFile : subFiles) {
                    size += subFile.length();
                }
                this.virtDriveSize += size;
                this.splitFileSize.put(nspFile.getName(), size);
                continue;
            }
            this.virtDriveSize += nspFile.length();
        }
        block23: while (true) {
            byte[] readByte;
            if ((readByte = this.readGL()) == null) {
                return;
            }
            if (!Arrays.equals(Arrays.copyOfRange(readByte, 0, 4), CMD_GLCI)) continue;
            switch (readByte[4]) {
                case 1: {
                    if (!this.getDriveCount()) continue block23;
                    break block23;
                }
                case 2: {
                    if (!this.getDriveInfo(DataConvertUtils.arrToIntLE(readByte, 8))) continue block23;
                    break block23;
                }
                case 15: {
                    if (!this.getSpecialPathCount()) continue block23;
                    break block23;
                }
                case 16: {
                    if (!this.getSpecialPath(DataConvertUtils.arrToIntLE(readByte, 8))) continue block23;
                    break block23;
                }
                case 6: {
                    int someLength1 = DataConvertUtils.arrToIntLE(readByte, 8) * 2;
                    if (!this.getDirectoryOrFileCount(new String(readByte, 12, someLength1, StandardCharsets.UTF_16LE), true)) continue block23;
                    break block23;
                }
                case 4: {
                    int someLength1 = DataConvertUtils.arrToIntLE(readByte, 8) * 2;
                    if (!this.getDirectoryOrFileCount(new String(readByte, 12, someLength1, StandardCharsets.UTF_16LE), false)) continue block23;
                    break block23;
                }
                case 7: {
                    int someLength1 = DataConvertUtils.arrToIntLE(readByte, 8) * 2;
                    if (!this.getDirectory(new String(readByte, 12, someLength1, StandardCharsets.UTF_16LE), DataConvertUtils.arrToIntLE(readByte, someLength1 + 12))) continue block23;
                    break block23;
                }
                case 5: {
                    int someLength1 = DataConvertUtils.arrToIntLE(readByte, 8) * 2;
                    if (!this.getFile(new String(readByte, 12, someLength1, StandardCharsets.UTF_16LE), DataConvertUtils.arrToIntLE(readByte, someLength1 + 12))) continue block23;
                    break block23;
                }
                case 3: {
                    int someLength1 = DataConvertUtils.arrToIntLE(readByte, 8) * 2;
                    if (!this.statPath(new String(readByte, 12, someLength1, StandardCharsets.UTF_16LE))) continue block23;
                    break block23;
                }
                case 14: {
                    int someLength2;
                    int someLength1 = DataConvertUtils.arrToIntLE(readByte, 12) * 2;
                    if (!this.rename(new String(readByte, 16, someLength1, StandardCharsets.UTF_16LE), new String(readByte, 16 + someLength1 + 4, someLength2 = DataConvertUtils.arrToIntLE(readByte, 16 + someLength1) * 2, StandardCharsets.UTF_16LE))) continue block23;
                    break block23;
                }
                case 13: {
                    int someLength1 = DataConvertUtils.arrToIntLE(readByte, 12) * 2;
                    if (!this.delete(new String(readByte, 16, someLength1, StandardCharsets.UTF_16LE))) continue block23;
                    break block23;
                }
                case 12: {
                    int someLength1 = DataConvertUtils.arrToIntLE(readByte, 12) * 2;
                    if (!this.create(new String(readByte, 16, someLength1, StandardCharsets.UTF_16LE), readByte[8])) continue block23;
                    break block23;
                }
                case 9: {
                    int someLength1 = DataConvertUtils.arrToIntLE(readByte, 8) * 2;
                    if (!this.readFile(new String(readByte, 12, someLength1, StandardCharsets.UTF_16LE), DataConvertUtils.arrToLongLE(readByte, 12 + someLength1), DataConvertUtils.arrToLongLE(readByte, 12 + someLength1 + 8))) continue block23;
                    break block23;
                }
                case 10: {
                    int someLength1 = DataConvertUtils.arrToIntLE(readByte, 8) * 2;
                    if (!this.writeFile(new String(readByte, 12, someLength1, StandardCharsets.UTF_16LE))) continue block23;
                    break block23;
                }
                case 17: {
                    if (!this.selectFile()) continue block23;
                    break block23;
                }
                case 8: 
                case 11: {
                    if (!this.startOrEndFile()) continue block23;
                    break block23;
                }
                default: {
                    this.writeGL_FAIL("GL Unknown command: " + readByte[4] + " [it's a very bad sign]");
                    continue block23;
                }
            }
            break;
        }
        if (!this.writeFilesMap.isEmpty()) {
            for (BufferedOutputStream fBufOutStream : this.writeFilesMap.values()) {
                try {
                    fBufOutStream.close();
                }
                catch (IOException | NullPointerException exception) {}
            }
        }
        this.closeOpenedReadFilesGl();
    }

    private void closeOpenedReadFilesGl() {
        if (this.openReadFileNameAndPath != null) {
            try {
                this.randAccessFile.close();
            }
            catch (IOException | NullPointerException exception) {
                // empty catch block
            }
            try {
                this.splitReader.close();
            }
            catch (IOException | NullPointerException exception) {
                // empty catch block
            }
            this.openReadFileNameAndPath = null;
            this.randAccessFile = null;
            this.splitReader = null;
        }
    }

    private boolean startOrEndFile() {
        if (this.writeGL_PASS()) {
            this.print("GL Handle 'StartFile' command", EMsgType.FAIL);
            return true;
        }
        return false;
    }

    private boolean getDriveCount() {
        byte[] drivesCnt = DataConvertUtils.intToArrLE(2);
        if (this.writeGL_PASS(drivesCnt)) {
            this.print("GL Handle 'ListDrives' command", EMsgType.FAIL);
            return true;
        }
        return false;
    }

    private boolean getDriveInfo(int driveNo) {
        byte[] totalSize;
        byte[] totalFreeSpace;
        byte[] driveLetterLen;
        byte[] driveLetter;
        byte[] driveLabelLen;
        byte[] driveLabel;
        if (driveNo < 0 || driveNo > 1) {
            return this.writeGL_FAIL("GL Handle 'GetDriveInfo' command [no such drive]");
        }
        if (driveNo == 0) {
            driveLabel = "Virtual".getBytes(StandardCharsets.UTF_16LE);
            driveLabelLen = DataConvertUtils.intToArrLE(driveLabel.length / 2);
            driveLetter = "VIRT".getBytes(StandardCharsets.UTF_16LE);
            driveLetterLen = DataConvertUtils.intToArrLE(driveLetter.length / 2);
            totalFreeSpace = new byte[4];
            long totalSizeLong = this.virtDriveSize;
            totalSize = Arrays.copyOfRange(DataConvertUtils.longToArrLE(totalSizeLong), 0, 4);
        } else {
            driveLabel = "Home".getBytes(StandardCharsets.UTF_16LE);
            driveLabelLen = DataConvertUtils.intToArrLE(driveLabel.length / 2);
            driveLetter = "HOME".getBytes(StandardCharsets.UTF_16LE);
            driveLetterLen = DataConvertUtils.intToArrLE(driveLetter.length / 2);
            File userHomeDir = new File(System.getProperty("user.home"));
            long totalFreeSpaceLong = userHomeDir.getFreeSpace();
            totalFreeSpace = Arrays.copyOfRange(DataConvertUtils.longToArrLE(totalFreeSpaceLong), 0, 4);
            long totalSizeLong = userHomeDir.getTotalSpace();
            totalSize = Arrays.copyOfRange(DataConvertUtils.longToArrLE(totalSizeLong), 0, 4);
        }
        LinkedList<byte[]> command = new LinkedList<byte[]>();
        command.add(driveLabelLen);
        command.add(driveLabel);
        command.add(driveLetterLen);
        command.add(driveLetter);
        command.add(totalFreeSpace);
        command.add(totalSize);
        if (this.writeGL_PASS(command)) {
            this.print("GL Handle 'GetDriveInfo' command", EMsgType.FAIL);
            return true;
        }
        return false;
    }

    private boolean getSpecialPathCount() {
        byte[] specialPathCnt = DataConvertUtils.intToArrLE(0);
        if (this.writeGL_PASS(specialPathCnt)) {
            this.print("GL Handle 'SpecialPathCount' command", EMsgType.FAIL);
            return true;
        }
        return false;
    }

    private boolean getSpecialPath(int specialPathNo) {
        return this.writeGL_FAIL("GL Handle 'SpecialPath' command [not supported]");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean getDirectoryOrFileCount(String path, boolean isGetDirectoryCount) {
        if (path.equals("VIRT:/")) {
            if (isGetDirectoryCount) {
                if (!this.writeGL_PASS()) return false;
                this.print("GL Handle 'GetDirectoryCount' command", EMsgType.FAIL);
                return true;
            }
            if (!this.writeGL_PASS(DataConvertUtils.intToArrLE(this.nspMap.size()))) return false;
            this.print("GL Handle 'GetFileCount' command Count = " + this.nspMap.size(), EMsgType.FAIL);
            return true;
        }
        if (path.startsWith("HOME:/")) {
            File pathDir = new File(path = this.updateHomePath(path));
            if (!pathDir.exists() || !pathDir.isDirectory()) {
                return this.writeGL_FAIL("GL Handle 'GetDirectoryOrFileCount' command [doesn't exist or not a folder]");
            }
            this.recentPath = path;
            String[] filesOrDirs = isGetDirectoryCount ? pathDir.list((current, name) -> {
                File dir = new File(current, name);
                return dir.isDirectory() && !dir.isHidden();
            }) : (this.nspFilterForGl ? pathDir.list((current, name) -> {
                File dir = new File(current, name);
                return !dir.isDirectory() && name.toLowerCase().endsWith(".nsp");
            }) : pathDir.list((current, name) -> {
                File dir = new File(current, name);
                return !dir.isDirectory() && !dir.isHidden();
            }));
            if (filesOrDirs == null) {
                if (!this.writeGL_PASS()) return false;
                this.print("GL Handle 'GetDirectoryOrFileCount' command", EMsgType.FAIL);
                return true;
            }
            Arrays.sort(filesOrDirs, String.CASE_INSENSITIVE_ORDER);
            if (isGetDirectoryCount) {
                this.recentDirs = filesOrDirs;
            } else {
                this.recentFiles = filesOrDirs;
            }
            if (!this.writeGL_PASS(DataConvertUtils.intToArrLE(filesOrDirs.length))) return false;
            this.print("GL Handle 'GetDirectoryOrFileCount' command", EMsgType.FAIL);
            return true;
        }
        if (!path.startsWith("SPEC:/")) return this.writeGL_FAIL("GL Handle 'GetDirectoryOrFileCount' command [unknown drive request] " + (isGetDirectoryCount ? "(dir) - " : "(file) - ") + path);
        if (isGetDirectoryCount) {
            if (!this.writeGL_PASS()) return false;
            this.print("GL Handle 'GetDirectoryCount' command", EMsgType.FAIL);
            return true;
        }
        if (this.selectedFile == null) return this.writeGL_FAIL("GL Handle 'GetDirectoryOrFileCount' command [unknown drive request] (file) - " + path);
        if (!this.writeGL_PASS(DataConvertUtils.intToArrLE(1))) return false;
        this.print("GL Handle 'GetFileCount' command Count = 1", EMsgType.FAIL);
        return true;
    }

    private boolean getDirectory(String dirName, int subDirNo) {
        if (dirName.startsWith("HOME:/")) {
            dirName = this.updateHomePath(dirName);
            LinkedList<byte[]> command = new LinkedList<byte[]>();
            if (dirName.equals(this.recentPath) && this.recentDirs != null && this.recentDirs.length != 0) {
                byte[] dirNameBytes = this.recentDirs[subDirNo].getBytes(StandardCharsets.UTF_16LE);
                command.add(DataConvertUtils.intToArrLE(dirNameBytes.length / 2));
                command.add(dirNameBytes);
            } else {
                File pathDir = new File(dirName);
                if (!pathDir.exists() || !pathDir.isDirectory()) {
                    return this.writeGL_FAIL("GL Handle 'GetDirectory' command [doesn't exist or not a folder]");
                }
                this.recentPath = dirName;
                this.recentDirs = pathDir.list((current, name) -> {
                    File dir = new File(current, name);
                    return dir.isDirectory() && !dir.isHidden();
                });
                if (this.recentDirs != null && this.recentDirs.length > subDirNo) {
                    Arrays.sort(this.recentFiles, String.CASE_INSENSITIVE_ORDER);
                    byte[] dirBytesName = this.recentDirs[subDirNo].getBytes(StandardCharsets.UTF_16LE);
                    command.add(DataConvertUtils.intToArrLE(dirBytesName.length / 2));
                    command.add(dirBytesName);
                } else {
                    return this.writeGL_FAIL("GL Handle 'GetDirectory' command [doesn't exist or not a folder]");
                }
            }
            if (this.writeGL_PASS(command)) {
                this.print("GL Handle 'GetDirectory' command.", EMsgType.FAIL);
                return true;
            }
            return false;
        }
        return this.writeGL_FAIL("GL Handle 'GetDirectory' command for virtual drive [no folders support]");
    }

    private boolean getFile(String dirName, int subDirNo) {
        LinkedList<byte[]> command = new LinkedList<byte[]>();
        if (dirName.startsWith("HOME:/")) {
            if ((dirName = this.updateHomePath(dirName)).equals(this.recentPath) && this.recentFiles != null && this.recentFiles.length != 0) {
                byte[] fileNameBytes = this.recentFiles[subDirNo].getBytes(StandardCharsets.UTF_16LE);
                command.add(DataConvertUtils.intToArrLE(fileNameBytes.length / 2));
                command.add(fileNameBytes);
            } else {
                File pathDir = new File(dirName);
                if (!pathDir.exists() || !pathDir.isDirectory()) {
                    this.writeGL_FAIL("GL Handle 'GetFile' command [doesn't exist or not a folder]");
                }
                this.recentPath = dirName;
                this.recentFiles = this.nspFilterForGl ? pathDir.list((current, name) -> {
                    File dir = new File(current, name);
                    return !dir.isDirectory() && name.toLowerCase().endsWith(".nsp");
                }) : pathDir.list((current, name) -> {
                    File dir = new File(current, name);
                    return !dir.isDirectory() && !dir.isHidden();
                });
                if (this.recentFiles != null && this.recentFiles.length > subDirNo) {
                    Arrays.sort(this.recentFiles, String.CASE_INSENSITIVE_ORDER);
                    byte[] fileNameBytes = this.recentFiles[subDirNo].getBytes(StandardCharsets.UTF_16LE);
                    command.add(DataConvertUtils.intToArrLE(fileNameBytes.length / 2));
                    command.add(fileNameBytes);
                } else {
                    return this.writeGL_FAIL("GL Handle 'GetFile' command [doesn't exist or not a folder]");
                }
            }
            if (this.writeGL_PASS(command)) {
                this.print("GL Handle 'GetFile' command.", EMsgType.FAIL);
                return true;
            }
            return false;
        }
        if (dirName.equals("VIRT:/")) {
            if (!this.nspMap.isEmpty()) {
                byte[] fileNameBytes = this.nspMapKeySetIndexes[subDirNo].getBytes(StandardCharsets.UTF_16LE);
                command.add(DataConvertUtils.intToArrLE(fileNameBytes.length / 2));
                command.add(fileNameBytes);
                if (this.writeGL_PASS(command)) {
                    this.print("GL Handle 'GetFile' command.", EMsgType.FAIL);
                    return true;
                }
                return false;
            }
        } else if (dirName.equals("SPEC:/") && this.selectedFile != null) {
            byte[] fileNameBytes = this.selectedFile.getName().getBytes(StandardCharsets.UTF_16LE);
            command.add(DataConvertUtils.intToArrLE(fileNameBytes.length / 2));
            command.add(fileNameBytes);
            if (this.writeGL_PASS(command)) {
                this.print("GL Handle 'GetFile' command.", EMsgType.FAIL);
                return true;
            }
            return false;
        }
        return this.writeGL_FAIL("GL Handle 'GetFile' command for virtual drive [no folders support?]");
    }

    private boolean statPath(String filePath) {
        LinkedList<byte[]> command = new LinkedList<byte[]>();
        if (filePath.startsWith("HOME:/")) {
            File fileDirElement = new File(filePath = this.updateHomePath(filePath));
            if (fileDirElement.exists()) {
                if (fileDirElement.isDirectory()) {
                    command.add(this.GL_OBJ_TYPE_DIR);
                } else {
                    command.add(this.GL_OBJ_TYPE_FILE);
                    command.add(DataConvertUtils.longToArrLE(fileDirElement.length()));
                }
                if (this.writeGL_PASS(command)) {
                    this.print("GL Handle 'StatPath' command.", EMsgType.FAIL);
                    return true;
                }
                return false;
            }
        } else if (filePath.startsWith("VIRT:/")) {
            if (this.nspMap.containsKey(filePath = filePath.replaceFirst("VIRT:/", ""))) {
                command.add(this.GL_OBJ_TYPE_FILE);
                if (((File)this.nspMap.get(filePath)).isDirectory()) {
                    command.add(DataConvertUtils.longToArrLE(this.splitFileSize.get(filePath)));
                } else {
                    command.add(DataConvertUtils.longToArrLE(((File)this.nspMap.get(filePath)).length()));
                }
                if (this.writeGL_PASS(command)) {
                    this.print("GL Handle 'StatPath' command.", EMsgType.FAIL);
                    return true;
                }
                return false;
            }
        } else if (filePath.startsWith("SPEC:/")) {
            filePath = filePath.replaceFirst("SPEC:/", "");
            if (this.selectedFile.getName().equals(filePath)) {
                command.add(this.GL_OBJ_TYPE_FILE);
                command.add(DataConvertUtils.longToArrLE(this.selectedFile.length()));
                if (this.writeGL_PASS(command)) {
                    this.print("GL Handle 'StatPath' command.", EMsgType.FAIL);
                    return true;
                }
                return false;
            }
        }
        return this.writeGL_FAIL("GL Handle 'StatPath' command [no such folder] - " + filePath);
    }

    private boolean rename(String fileName, String newFileName) {
        if (fileName.startsWith("HOME:/")) {
            this.recentPath = null;
            this.recentFiles = null;
            this.recentDirs = null;
            fileName = this.updateHomePath(fileName);
            newFileName = this.updateHomePath(newFileName);
            File currentFile = new File(fileName);
            File newFile = new File(newFileName);
            if (!newFile.exists()) {
                try {
                    if (currentFile.renameTo(newFile)) {
                        if (this.writeGL_PASS()) {
                            this.print("GL Handle 'Rename' command.", EMsgType.FAIL);
                            return true;
                        }
                        return false;
                    }
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
        }
        return this.writeGL_FAIL("GL Handle 'Rename' command [not supported for virtual drive/wrong drive/file with such name already exists/read-only directory]");
    }

    private boolean delete(String fileName) {
        if (fileName.startsWith("HOME:/")) {
            fileName = this.updateHomePath(fileName);
            File fileToDel = new File(fileName);
            try {
                if (fileToDel.delete()) {
                    if (this.writeGL_PASS()) {
                        this.print("GL Handle 'Rename' command.", EMsgType.FAIL);
                        return true;
                    }
                    return false;
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return this.writeGL_FAIL("GL Handle 'Delete' command [not supported for virtual drive/wrong drive/read-only directory]");
    }

    private boolean create(String fileName, byte type) {
        if (fileName.startsWith("HOME:/")) {
            fileName = this.updateHomePath(fileName);
            File fileToCreate = new File(fileName);
            boolean result = false;
            if (type == 1) {
                try {
                    result = fileToCreate.createNewFile();
                }
                catch (IOException | SecurityException exception) {}
            } else if (type == 2) {
                try {
                    result = fileToCreate.mkdir();
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
            if (result) {
                if (this.writeGL_PASS()) {
                    this.print("GL Handle 'Create' command.", EMsgType.FAIL);
                    return true;
                }
                return false;
            }
        }
        return this.writeGL_FAIL("GL Handle 'Delete' command [not supported for virtual drive/wrong drive/read-only directory]");
    }

    private boolean readFile(String fileName, long offset, long size) {
        if (fileName.startsWith("VIRT:/")) {
            String fNamePath = ((File)this.nspMap.get(fileName.substring(6))).getAbsolutePath();
            if (this.openReadFileNameAndPath == null || !this.openReadFileNameAndPath.equals(fNamePath)) {
                if (this.openReadFileNameAndPath != null) {
                    try {
                        this.randAccessFile.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        this.splitReader.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                try {
                    File tempFile = (File)this.nspMap.get(fileName.substring(6));
                    if (tempFile.isDirectory()) {
                        this.randAccessFile = null;
                        this.splitReader = new NSSplitReader(tempFile, 0L);
                    } else {
                        this.splitReader = null;
                        this.randAccessFile = new RandomAccessFile(tempFile, "r");
                    }
                    this.openReadFileNameAndPath = fNamePath;
                }
                catch (IOException | NullPointerException ioe) {
                    return this.writeGL_FAIL("GL Handle 'ReadFile' command\n\t" + ioe.getMessage());
                }
            }
        } else {
            fileName = this.updateHomePath(fileName);
            if (this.openReadFileNameAndPath == null || !this.openReadFileNameAndPath.equals(fileName)) {
                if (this.openReadFileNameAndPath != null) {
                    try {
                        this.randAccessFile.close();
                    }
                    catch (IOException | NullPointerException fNamePath) {
                        // empty catch block
                    }
                }
                try {
                    this.randAccessFile = new RandomAccessFile(fileName, "r");
                    this.openReadFileNameAndPath = fileName;
                }
                catch (IOException | NullPointerException ioe) {
                    return this.writeGL_FAIL("GL Handle 'ReadFile' command\n\t" + ioe.getMessage());
                }
            }
        }
        try {
            byte[] chunk;
            if (this.randAccessFile == null) {
                this.splitReader.seek(offset);
                chunk = new byte[(int)size];
                int bytesRead = this.splitReader.read(chunk);
                if (bytesRead != (int)size) {
                    return this.writeGL_FAIL("GL Handle 'ReadFile' command [CMD]\n         At offset: " + offset + "\n         Requested: " + size + "\n         Received:  " + bytesRead);
                }
                if (this.writeGL_PASS(DataConvertUtils.longToArrLE(size))) {
                    this.print("GL Handle 'ReadFile' command [CMD]", EMsgType.FAIL);
                    return true;
                }
                if (this.writeToUsb(chunk)) {
                    this.print("GL Handle 'ReadFile' command", EMsgType.FAIL);
                    return true;
                }
                return false;
            }
            this.randAccessFile.seek(offset);
            chunk = new byte[(int)size];
            int bytesRead = this.randAccessFile.read(chunk);
            if (bytesRead != (int)size) {
                return this.writeGL_FAIL("GL Handle 'ReadFile' command [CMD] Requested = " + size + " Read from file = " + bytesRead);
            }
            if (this.writeGL_PASS(DataConvertUtils.longToArrLE(size))) {
                this.print("GL Handle 'ReadFile' command [CMD]", EMsgType.FAIL);
                return true;
            }
            if (this.writeToUsb(chunk)) {
                this.print("GL Handle 'ReadFile' command", EMsgType.FAIL);
                return true;
            }
            return false;
        }
        catch (Exception ioe) {
            try {
                this.randAccessFile.close();
            }
            catch (NullPointerException bytesRead) {
            }
            catch (IOException ioe_) {
                this.print("GL Handle 'ReadFile' command: unable to close: " + this.openReadFileNameAndPath + "\n\t" + ioe_.getMessage(), EMsgType.WARNING);
            }
            try {
                this.splitReader.close();
            }
            catch (NullPointerException ioe_) {
            }
            catch (IOException ioe_) {
                this.print("GL Handle 'ReadFile' command: unable to close: " + this.openReadFileNameAndPath + "\n\t" + ioe_.getMessage(), EMsgType.WARNING);
            }
            this.openReadFileNameAndPath = null;
            this.randAccessFile = null;
            this.splitReader = null;
            return this.writeGL_FAIL("GL Handle 'ReadFile' command\n\t" + ioe.getMessage());
        }
    }

    private boolean writeFile(String fileName) {
        if (fileName.startsWith("VIRT:/")) {
            return this.writeGL_FAIL("GL Handle 'WriteFile' command [not supported for virtual drive]");
        }
        fileName = this.updateHomePath(fileName);
        if (this.writeFilesMap.size() == 0 || !this.writeFilesMap.containsKey(fileName)) {
            File writeFile = new File(fileName);
            try {
                BufferedOutputStream writeFileBufOutStream = new BufferedOutputStream(new FileOutputStream(writeFile, true));
                this.writeFilesMap.put(fileName, writeFileBufOutStream);
            }
            catch (IOException ioe) {
                return this.writeGL_FAIL("GL Handle 'WriteFile' command [IOException]\n\t" + ioe.getMessage());
            }
        }
        BufferedOutputStream myStream = this.writeFilesMap.get(fileName);
        byte[] transferredData = this.readGL_file();
        if (transferredData == null) {
            this.print("GL Handle 'WriteFile' command [1/1]", EMsgType.FAIL);
            return true;
        }
        try {
            myStream.write(transferredData, 0, transferredData.length);
        }
        catch (IOException ioe) {
            return this.writeGL_FAIL("GL Handle 'WriteFile' command [1/1]\n\t" + ioe.getMessage());
        }
        if (this.writeGL_PASS()) {
            this.print("GL Handle 'WriteFile' command", EMsgType.FAIL);
            return true;
        }
        return false;
    }

    private boolean selectFile() {
        File selectedFile = CompletableFuture.supplyAsync(() -> {
            FileChooser fChooser = new FileChooser();
            fChooser.setTitle(MediatorControl.INSTANCE.getResourceBundle().getString("btn_OpenFile"));
            fChooser.setInitialDirectory(new File(System.getProperty("user.home")));
            fChooser.getExtensionFilters().add(new FileChooser.ExtensionFilter("*", "*"));
            return fChooser.showOpenDialog(null);
        }, Platform::runLater).join();
        if (selectedFile == null) {
            this.selectedFile = null;
            return this.writeGL_FAIL("GL Handle 'SelectFile' command: Nothing selected");
        }
        LinkedList<byte[]> command = new LinkedList<byte[]>();
        byte[] selectedFileNameBytes = ("SPEC:/" + selectedFile.getName()).getBytes(StandardCharsets.UTF_16LE);
        command.add(DataConvertUtils.intToArrLE(selectedFileNameBytes.length / 2));
        command.add(selectedFileNameBytes);
        if (this.writeGL_PASS(command)) {
            this.print("GL Handle 'SelectFile' command", EMsgType.FAIL);
            this.selectedFile = null;
            return true;
        }
        this.selectedFile = selectedFile;
        return false;
    }

    private String updateHomePath(String glPath) {
        if (this.isWindows) {
            glPath = ((String)glPath).replaceAll("/", "\\\\");
        }
        glPath = this.homePath + ((String)glPath).substring(6);
        return glPath;
    }

    private byte[] readGL() {
        ByteBuffer readBuffer = ByteBuffer.allocateDirect(4096);
        IntBuffer rBufferTransferred = IntBuffer.allocate(1);
        block4: while (!this.task.isCancelled()) {
            int result = LibUsb.bulkTransfer(this.handlerNS, (byte)-127, readBuffer, rBufferTransferred, 1000L);
            switch (result) {
                case 0: {
                    byte[] receivedBytes = new byte[rBufferTransferred.get()];
                    readBuffer.get(receivedBytes);
                    return receivedBytes;
                }
                case -7: {
                    this.closeOpenedReadFilesGl();
                    continue block4;
                }
            }
            this.print("GL Data transfer issue [read]\n         Returned: " + LibUsb.errorName(result) + "\n         GL Execution stopped", EMsgType.FAIL);
            return null;
        }
        this.print("GL Execution interrupted", EMsgType.INFO);
        return null;
    }

    private byte[] readGL_file() {
        ByteBuffer readBuffer = ByteBuffer.allocateDirect(0x800000);
        IntBuffer rBufferTransferred = IntBuffer.allocate(1);
        block4: while (!this.task.isCancelled()) {
            int result = LibUsb.bulkTransfer(this.handlerNS, (byte)-127, readBuffer, rBufferTransferred, 1000L);
            switch (result) {
                case 0: {
                    byte[] receivedBytes = new byte[rBufferTransferred.get()];
                    readBuffer.get(receivedBytes);
                    return receivedBytes;
                }
                case -7: {
                    continue block4;
                }
            }
            this.print("GL Data transfer issue [read]\n         Returned: " + LibUsb.errorName(result) + "\n         GL Execution stopped", EMsgType.FAIL);
            return null;
        }
        this.print("GL Execution interrupted", EMsgType.INFO);
        return null;
    }

    private boolean writeGL_PASS(byte[] message) {
        return this.writeToUsb(ByteBuffer.allocate(4096).put(this.CMD_GLCO_SUCCESS).put(message).array());
    }

    private boolean writeGL_PASS() {
        return this.writeToUsb(Arrays.copyOf(this.CMD_GLCO_SUCCESS, 4096));
    }

    private boolean writeGL_PASS(List<byte[]> messages) {
        ByteBuffer writeBuffer = ByteBuffer.allocate(4096).put(this.CMD_GLCO_SUCCESS);
        messages.forEach(writeBuffer::put);
        return this.writeToUsb(writeBuffer.array());
    }

    private boolean writeGL_FAIL(String reportToUImsg) {
        if (this.writeToUsb(Arrays.copyOf(this.CMD_GLCO_FAILURE, 4096))) {
            this.print(reportToUImsg, EMsgType.WARNING);
            return true;
        }
        this.print(reportToUImsg, EMsgType.FAIL);
        return false;
    }

    private boolean writeToUsb(byte[] message) {
        IntBuffer wBufferTransferred = IntBuffer.allocate(1);
        block4: while (!this.task.isCancelled()) {
            int result = LibUsb.bulkTransfer(this.handlerNS, (byte)1, ByteBuffer.allocateDirect(message.length).put(message), wBufferTransferred, 1000L);
            switch (result) {
                case 0: {
                    if (wBufferTransferred.get() == message.length) {
                        return false;
                    }
                    this.print("Data transfer issue [write]\n         Requested: " + message.length + "\n         Transferred: " + wBufferTransferred.get(), EMsgType.FAIL);
                    return true;
                }
                case -7: {
                    continue block4;
                }
            }
            this.print("GL Data transfer issue [write]\n  Returned: " + LibUsb.errorName(result), EMsgType.FAIL);
            this.print("GL Execution stopped", EMsgType.FAIL);
            return true;
        }
        this.print("GL Execution interrupted", EMsgType.INFO);
        return true;
    }
}

