/*
 * Decompiled with CFR 0.152.
 */
package nsusbloader.com.usb;

import nsusbloader.ModelControllers.ILogPrinter;
import nsusbloader.NSLDataTypes.EMsgType;
import org.usb4java.Context;
import org.usb4java.Device;
import org.usb4java.DeviceDescriptor;
import org.usb4java.DeviceHandle;
import org.usb4java.DeviceList;
import org.usb4java.LibUsb;

public class UsbConnect {
    private static final int DEFAULT_INTERFACE = 0;
    private static final int DEFAULT_HOMEBREW_CONFIGURATION = 1;
    private static final short RCM_VID = 2389;
    private static final short RCM_PID = 29473;
    private static final short HOMEBREW_VID = 1406;
    private static final short HOMEBREW_PID = 12288;
    private Context contextNS;
    private DeviceHandle handlerNS;
    private Device deviceNS;
    private ILogPrinter logPrinter;
    private boolean connected;
    private short VENDOR_ID;
    private short PRODUCT_ID;
    private int returningValue;
    private DeviceList deviceList;

    public static UsbConnect connectRcmMode(ILogPrinter logPrinter) {
        UsbConnect usbConnect = new UsbConnect(logPrinter);
        usbConnect.VENDOR_ID = (short)2389;
        usbConnect.PRODUCT_ID = (short)29473;
        try {
            usbConnect.createContextAndInitLibUSB();
            usbConnect.getDeviceList();
            usbConnect.findDevice();
            usbConnect.openDevice();
            usbConnect.freeDeviceList();
            usbConnect.setAutoDetachKernelDriver();
            usbConnect.claimInterface();
            usbConnect.connected = true;
        }
        catch (Exception e) {
            try {
                logPrinter.print(e.getMessage(), EMsgType.FAIL);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            usbConnect.close();
        }
        return usbConnect;
    }

    public static UsbConnect connectHomebrewMode(ILogPrinter logPrinter) {
        UsbConnect usbConnect = new UsbConnect(logPrinter);
        usbConnect.VENDOR_ID = (short)1406;
        usbConnect.PRODUCT_ID = (short)12288;
        try {
            usbConnect.createContextAndInitLibUSB();
            usbConnect.getDeviceList();
            usbConnect.findDevice();
            usbConnect.openDevice();
            usbConnect.freeDeviceList();
            usbConnect.setAutoDetachKernelDriver();
            usbConnect.setConfiguration(1);
            usbConnect.claimInterface();
            usbConnect.connected = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                logPrinter.print(e.getMessage(), EMsgType.FAIL);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            usbConnect.close();
        }
        return usbConnect;
    }

    private UsbConnect() {
    }

    private UsbConnect(ILogPrinter logPrinter) {
        this.logPrinter = logPrinter;
        this.connected = false;
    }

    private void createContextAndInitLibUSB() throws Exception {
        this.contextNS = new Context();
        this.returningValue = LibUsb.init(this.contextNS);
        if (this.returningValue != 0) {
            throw new Exception("LibUSB initialization failed: " + LibUsb.errorName(this.returningValue));
        }
    }

    private void getDeviceList() throws Exception {
        this.deviceList = new DeviceList();
        this.returningValue = LibUsb.getDeviceList(this.contextNS, this.deviceList);
        if (this.returningValue < 0) {
            throw new Exception("Can't get device list: " + LibUsb.errorName(this.returningValue));
        }
    }

    private void findDevice() throws Exception {
        for (Device device : this.deviceList) {
            DeviceDescriptor descriptor = this.getDeviceDescriptor(device);
            if (descriptor.idVendor() != this.VENDOR_ID || descriptor.idProduct() != this.PRODUCT_ID) continue;
            this.deviceNS = device;
            break;
        }
        if (this.deviceNS == null) {
            this.freeDeviceList();
            throw new Exception("NS not found in connected USB devices");
        }
    }

    private DeviceDescriptor getDeviceDescriptor(Device device) throws Exception {
        DeviceDescriptor descriptor = new DeviceDescriptor();
        this.returningValue = LibUsb.getDeviceDescriptor(device, descriptor);
        if (this.returningValue != 0) {
            this.freeDeviceList();
            throw new Exception("Get USB device descriptor failure: " + LibUsb.errorName(this.returningValue));
        }
        return descriptor;
    }

    private void openDevice() throws Exception {
        this.handlerNS = new DeviceHandle();
        this.returningValue = LibUsb.open(this.deviceNS, this.handlerNS);
        if (this.returningValue == 0) {
            return;
        }
        this.handlerNS = null;
        if (this.returningValue == -3) {
            throw new Exception(String.format("Can't open NS USB device: %s\nDouble check that you have administrator privileges (you're 'root') or check 'udev' rules set for this user (linux only)!\n\nSteps to set 'udev' rules:\nroot # vim /etc/udev/rules.d/99-NS" + (2389 == this.VENDOR_ID ? "RCM" : "") + ".rules\nSUBSYSTEM==\"usb\", ATTRS{idVendor}==\"%04x\", ATTRS{idProduct}==\"%04x\", MODE=\"0666\"\nroot # udevadm control --reload-rules && udevadm trigger\n", LibUsb.errorName(this.returningValue), this.VENDOR_ID, this.PRODUCT_ID));
        }
        throw new Exception("Can't open NS USB device: " + LibUsb.errorName(this.returningValue));
    }

    private void freeDeviceList() {
        LibUsb.freeDeviceList(this.deviceList, true);
    }

    private void setAutoDetachKernelDriver() {
        this.returningValue = LibUsb.setAutoDetachKernelDriver(this.handlerNS, true);
        if (this.returningValue != 0) {
            this.print("Skip kernel driver attach & detach (" + LibUsb.errorName(this.returningValue) + ")", EMsgType.INFO);
        }
    }

    private void setConfiguration(int configuration) throws Exception {
        this.returningValue = LibUsb.setConfiguration(this.handlerNS, configuration);
        if (this.returningValue != 0) {
            throw new Exception("Unable to set active configuration on device: " + LibUsb.errorName(this.returningValue));
        }
    }

    private void claimInterface() throws Exception {
        this.returningValue = LibUsb.claimInterface(this.handlerNS, 0);
        if (this.returningValue != 0) {
            throw new Exception("Claim interface failure: " + LibUsb.errorName(this.returningValue));
        }
    }

    public boolean isConnected() {
        return this.connected;
    }

    public DeviceHandle getNsHandler() {
        return this.handlerNS;
    }

    public int getNsBus() {
        return LibUsb.getBusNumber(this.deviceNS);
    }

    public int getNsAddress() {
        return LibUsb.getDeviceAddress(this.deviceNS);
    }

    public void close() {
        if (this.handlerNS != null) {
            this.returningValue = LibUsb.releaseInterface(this.handlerNS, 0);
            if (this.returningValue != 0) {
                this.print("Release interface failure: " + LibUsb.errorName(this.returningValue) + " (sometimes it's not an issue)", EMsgType.WARNING);
            }
            LibUsb.close(this.handlerNS);
        }
        if (this.contextNS != null) {
            LibUsb.exit(this.contextNS);
        }
    }

    private void print(String message, EMsgType type) {
        try {
            this.logPrinter.print(message, type);
        }
        catch (InterruptedException ie) {
            ie.printStackTrace();
        }
    }
}

